/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.tracing;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TraceEvent {
    private long timestamp;
    private Action action;
    private String name;
    private int keyHash;
    private int weight;
    private long id;

    public TraceEvent() {
    }

    public TraceEvent(String name, long id, Action action, int keyHash, int weight, long timestamp) {
        this.timestamp = timestamp;
        this.keyHash = keyHash;
        this.action = action;
        this.name = name;
        this.id = id;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public long id() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Nullable
    public Action action() {
        return this.action;
    }

    public void setAction(@Nullable Action action) {
        this.action = action;
    }

    public int keyHash() {
        return this.keyHash;
    }

    public void setKeyHash(int keyHash) {
        this.keyHash = keyHash;
    }

    public int weight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void copyFrom(TraceEvent event) {
        this.timestamp = event.timestamp;
        this.keyHash = event.keyHash;
        this.action = event.action;
        this.weight = event.weight;
        this.name = event.name;
        this.id = event.id;
    }

    public static TraceEvent fromTextRecord(@Nonnull String[] record) {
        TraceEvent event = new TraceEvent();
        int index = 0;
        event.action = Action.valueOf(record[index++]);
        if (event.action == Action.REGISTER) {
            event.name = record[index++];
        }
        event.id = Long.parseLong(record[index++]);
        if (event.action != Action.REGISTER) {
            event.keyHash = Integer.parseInt(record[index++]);
            event.weight = Integer.parseInt(record[index++]);
        }
        event.timestamp = Long.parseLong(record[index++]);
        return event;
    }

    public void appendTextRecord(@Nonnull Appendable output) throws IOException {
        output.append(this.action.name());
        output.append(' ');
        if (this.action == Action.REGISTER) {
            output.append(this.name.replace(' ', '_'));
            output.append(' ');
        }
        output.append(Long.toString(this.id));
        output.append(' ');
        if (this.action != Action.REGISTER) {
            output.append(Integer.toString(this.keyHash));
            output.append(' ');
            output.append(Integer.toString(this.weight));
            output.append(' ');
        }
        output.append(Long.toString(this.timestamp));
    }

    public static TraceEvent fromBinaryRecord(@Nonnull DataInputStream input) throws IOException {
        TraceEvent event = new TraceEvent();
        event.action = Action.values()[input.readShort()];
        if (event.action == Action.REGISTER) {
            int length = input.readInt();
            char[] chars = new char[length];
            for (int i = 0; i < length; ++i) {
                chars[i] = input.readChar();
            }
            event.name = String.valueOf(chars);
        }
        event.id = input.readLong();
        if (event.action != Action.REGISTER) {
            event.keyHash = input.readInt();
            event.weight = input.readInt();
        }
        event.timestamp = input.readLong();
        return event;
    }

    public void appendBinaryRecord(@Nonnull DataOutputStream output) throws IOException {
        output.writeShort(this.action.ordinal());
        if (this.action == Action.REGISTER) {
            output.writeInt(this.name.length());
            output.writeChars(this.name);
        }
        output.writeLong(this.id);
        if (this.action != Action.REGISTER) {
            output.writeInt(this.keyHash);
            output.writeInt(this.weight);
        }
        output.writeLong(this.timestamp);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TraceEvent)) {
            return false;
        }
        TraceEvent event = (TraceEvent)o;
        return Objects.equals(this.timestamp, event.timestamp) && Objects.equals(this.keyHash, event.keyHash) && Objects.equals((Object)this.action, (Object)event.action) && Objects.equals(this.weight, event.weight) && Objects.equals(this.name, event.name) && Objects.equals(this.id, event.id);
    }

    public int hashCode() {
        return (int)(this.timestamp ^ this.id);
    }

    public String toString() {
        try {
            StringBuilder output = new StringBuilder();
            this.appendTextRecord(output);
            return output.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static enum Action {
        REGISTER,
        READ,
        WRITE,
        DELETE;

    }
}

