/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.segment;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admission;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

@Policy.PolicySpec(name="sketch.S4WindowTinyLfu")
public final class S4WindowTinyLfuPolicy
implements Policy.KeyOnlyPolicy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final Admittor admittor;
    private final Node[] headMainQ;
    private final int maximumSize;
    private final int[] sizeMainQ;
    private final Node headWindow;
    private final int maxWindow;
    private final int maxMain;
    private final int levels;
    private int sizeWindow;

    public S4WindowTinyLfuPolicy(double percentMain, S4WindowTinyLfuSettings settings) {
        this.policyStats = new PolicyStats(this.name() + " (%.0f%%)", 100.0 * (1.0 - percentMain));
        this.admittor = Admission.TINYLFU.from(settings.config(), this.policyStats);
        this.maximumSize = Math.toIntExact(settings.maximumSize());
        this.maxMain = (int)((double)this.maximumSize * percentMain);
        this.maxWindow = this.maximumSize - this.maxMain;
        this.data = new Long2ObjectOpenHashMap();
        this.headWindow = Node.sentinel(-1);
        this.levels = settings.levels();
        this.sizeMainQ = new int[this.levels];
        this.headMainQ = new Node[this.levels];
        Arrays.setAll(this.headMainQ, Node::sentinel);
    }

    public static Set<Policy> policies(Config config) {
        S4WindowTinyLfuSettings settings = new S4WindowTinyLfuSettings(config);
        return settings.percentMain().stream().map(percentMain -> new S4WindowTinyLfuPolicy((double)percentMain, settings)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        this.admittor.record(key);
        if (node == null) {
            this.onMiss(key);
            this.policyStats.recordMiss();
        } else if (node.status == Status.WINDOW) {
            this.onWindowHit(node);
            this.policyStats.recordHit();
        } else if (node.status == Status.MAIN) {
            this.onMainHit(node);
            this.policyStats.recordHit();
        } else {
            throw new IllegalStateException();
        }
    }

    private void onMiss(long key) {
        Node node = new Node(key, Status.WINDOW);
        node.appendToTail(this.headWindow);
        this.data.put(key, (Object)node);
        ++this.sizeWindow;
        this.evict();
    }

    private void onWindowHit(Node node) {
        node.moveToTail(this.headWindow);
    }

    private void onMainHit(Node node) {
        node.remove();
        int n = node.level;
        this.sizeMainQ[n] = this.sizeMainQ[n] - 1;
        if (node.level < this.levels - 1) {
            ++node.level;
        }
        Node head = this.headMainQ[node.level];
        node.appendToTail(head);
        int n2 = node.level;
        this.sizeMainQ[n2] = this.sizeMainQ[n2] + 1;
        this.adjust();
    }

    private void adjust() {
        int maxPerLevel = this.maxMain / this.levels;
        for (int i = this.levels - 1; i > 0; --i) {
            if (this.sizeMainQ[i] <= maxPerLevel) continue;
            Node demote = Objects.requireNonNull(this.headMainQ[i].next);
            demote.remove();
            int n = i;
            this.sizeMainQ[n] = this.sizeMainQ[n] - 1;
            int n2 = demote.level = i - 1;
            this.sizeMainQ[n2] = this.sizeMainQ[n2] + 1;
            demote.appendToTail(this.headMainQ[demote.level]);
        }
    }

    private void evict() {
        if (this.sizeWindow <= this.maxWindow) {
            return;
        }
        Node candidate = Objects.requireNonNull(this.headWindow.next);
        candidate.remove();
        --this.sizeWindow;
        candidate.appendToTail(this.headMainQ[0]);
        candidate.status = Status.MAIN;
        this.sizeMainQ[0] = this.sizeMainQ[0] + 1;
        if (this.data.size() > this.maximumSize) {
            Node victim = Objects.requireNonNull(this.headMainQ[0].next);
            Node evict = this.admittor.admit(candidate.key, victim.key) ? victim : candidate;
            this.data.remove(evict.key);
            evict.remove();
            this.sizeMainQ[0] = this.sizeMainQ[0] - 1;
            this.policyStats.recordEviction();
        }
    }

    @Override
    public void finished() {
        for (int i = 0; i < this.levels; ++i) {
            int level = i;
            long count = this.data.values().stream().filter(node -> node.status == Status.MAIN).filter(node -> node.level == level).count();
            Preconditions.checkState((count == (long)this.sizeMainQ[i] ? 1 : 0) != 0);
        }
        Preconditions.checkState((this.data.values().stream().filter(n -> n.status == Status.WINDOW).count() == (long)this.sizeWindow ? 1 : 0) != 0);
        Preconditions.checkState((this.data.size() <= this.maxWindow + this.maxMain ? 1 : 0) != 0);
    }

    public static final class S4WindowTinyLfuSettings
    extends BasicSettings {
        public S4WindowTinyLfuSettings(Config config) {
            super(config);
        }

        public int levels() {
            return this.config().getInt("s4-window-tiny-lfu.levels");
        }

        public List<Double> percentMain() {
            return this.config().getDoubleList("s4-window-tiny-lfu.percent-main");
        }
    }

    static final class Node {
        final long key;
        @Nullable Node prev;
        @Nullable Node next;
        @Nullable Status status;
        int level;

        public Node(long key, @Nullable Status status) {
            this.status = status;
            this.key = key;
        }

        static Node sentinel(int level) {
            Node node = new Node(Long.MIN_VALUE, null);
            node.level = level;
            node.prev = node;
            node.next = node;
            return node;
        }

        public void moveToTail(Node head) {
            this.remove();
            this.appendToTail(head);
        }

        public void appendToTail(Node head) {
            Objects.requireNonNull(head.prev);
            Node tail = head.prev;
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void remove() {
            Objects.requireNonNull(this.prev);
            Objects.requireNonNull(this.next);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = null;
            this.next = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("level", this.level).toString();
        }
    }

    static enum Status {
        WINDOW,
        MAIN;

    }
}

