/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.perfect;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Frequency;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;

public final class PerfectFrequency
implements Frequency {
    private final Long2IntMap counts = new Long2IntOpenHashMap();
    private final int sampleSize;
    private int size;

    public PerfectFrequency(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.sampleSize = Math.toIntExact(10L * settings.maximumSize());
    }

    @Override
    public int frequency(long e) {
        return this.counts.get(e);
    }

    @Override
    public void increment(long e) {
        this.counts.put(e, this.counts.get(e) + 1);
        ++this.size;
        if (this.size == this.sampleSize) {
            this.reset();
        }
    }

    private void reset() {
        ObjectIterator iterator = this.counts.long2IntEntrySet().iterator();
        while (iterator.hasNext()) {
            Long2IntMap.Entry entry = (Long2IntMap.Entry)iterator.next();
            int newValue = entry.getIntValue() / 2;
            if (newValue == 0) {
                iterator.remove();
                continue;
            }
            entry.setValue(newValue);
        }
        this.size /= 2;
    }
}

