/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.clairvoyant;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntPriorityQueue;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableInt;

public final class Clairvoyant
implements Admittor.KeyOnlyAdmittor {
    private static final AtomicReference<Long2ObjectMap<IntList>> snapshot = new AtomicReference();
    private final Long2ObjectMap<IntPriorityQueue> accessTimes;
    private final PolicyStats policyStats;

    public Clairvoyant(Config config, PolicyStats policyStats) {
        Long2ObjectMap<IntList> readOnlyAccessTimes = snapshot.get();
        if (readOnlyAccessTimes == null) {
            readOnlyAccessTimes = Clairvoyant.readAccessTimes(new BasicSettings(config));
            snapshot.set(readOnlyAccessTimes);
        }
        this.accessTimes = new Long2ObjectOpenHashMap(readOnlyAccessTimes.size());
        for (Long2ObjectMap.Entry entry : readOnlyAccessTimes.long2ObjectEntrySet()) {
            IntArrayFIFOQueue times = new IntArrayFIFOQueue(((IntList)entry.getValue()).size());
            this.accessTimes.put(entry.getLongKey(), (Object)times);
            ((IntList)entry.getValue()).forEach(arg_0 -> ((IntArrayFIFOQueue)times).enqueue(arg_0));
        }
        this.policyStats = policyStats;
    }

    @Override
    public void record(long key) {
        IntPriorityQueue times;
        if (snapshot.get() != null) {
            snapshot.set(null);
        }
        if ((times = (IntPriorityQueue)this.accessTimes.get(key)) == null) {
            return;
        }
        times.dequeueInt();
        if (times.isEmpty()) {
            this.accessTimes.remove(key);
        }
    }

    @Override
    public boolean admit(long candidateKey, long victimKey) {
        int victimTime;
        int candidateTime = this.nextAccessTime(candidateKey);
        if (candidateTime > (victimTime = this.nextAccessTime(victimKey))) {
            this.policyStats.recordRejection();
            return false;
        }
        this.policyStats.recordAdmission();
        return true;
    }

    private int nextAccessTime(long key) {
        IntPriorityQueue times = (IntPriorityQueue)this.accessTimes.get(key);
        return times == null || times.isEmpty() ? Integer.MAX_VALUE : times.firstInt();
    }

    private static Long2ObjectMap<IntList> readAccessTimes(BasicSettings settings) {
        Preconditions.checkState((!settings.trace().isSynthetic() ? 1 : 0) != 0, (Object)"Synthetic traces cannot be predicted");
        Long2ObjectOpenHashMap accessTimes = new Long2ObjectOpenHashMap();
        TraceReader trace = settings.trace().traceFiles().format().readFiles(settings.trace().traceFiles().paths());
        try (Stream<AccessEvent> events = trace.events();){
            MutableInt tick = new MutableInt();
            events.forEach(event -> {
                IntList times = (IntList)accessTimes.computeIfAbsent(event.key(), l -> new IntArrayList());
                times.add(tick.incrementAndGet());
            });
        }
        return Long2ObjectMaps.unmodifiable((Long2ObjectMap)accessTimes);
    }
}

