/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.two_queue;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@Policy.PolicySpec(name="two-queue.TwoQueue")
public final class TwoQueuePolicy
implements Policy.KeyOnlyPolicy {
    static final Node UNLINKED = new Node();
    final Long2ObjectMap<Node> data;
    final PolicyStats policyStats;
    final int maximumSize;
    int sizeIn;
    final int maxIn;
    final Node headIn;
    int sizeOut;
    final int maxOut;
    final Node headOut;
    int sizeMain;
    final Node headMain;

    public TwoQueuePolicy(Config config) {
        TwoQueueSettings settings = new TwoQueueSettings(config);
        this.headIn = new Node();
        this.headOut = new Node();
        this.headMain = new Node();
        this.data = new Long2ObjectOpenHashMap();
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        this.maximumSize = Math.toIntExact(settings.maximumSize());
        this.maxIn = (int)((double)this.maximumSize * settings.percentIn());
        this.maxOut = (int)((double)this.maximumSize * settings.percentOut());
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        if (node != null) {
            Objects.requireNonNull(node.type);
            switch (node.type.ordinal()) {
                case 0: {
                    node.moveToTail(this.headMain);
                    this.policyStats.recordHit();
                    return;
                }
                case 2: {
                    node.remove();
                    --this.sizeOut;
                    this.reclaimfor(node);
                    node.appendToTail(this.headMain);
                    node.type = QueueType.MAIN;
                    ++this.sizeMain;
                    this.policyStats.recordMiss();
                    return;
                }
                case 1: {
                    this.policyStats.recordHit();
                    return;
                }
            }
            throw new IllegalStateException("Unknown type: " + String.valueOf((Object)node.type));
        }
        node = new Node(key);
        node.type = QueueType.IN;
        this.reclaimfor(node);
        node.appendToTail(this.headIn);
        ++this.sizeIn;
        this.policyStats.recordMiss();
    }

    private void reclaimfor(Node node) {
        if (this.sizeMain + this.sizeIn < this.maximumSize) {
            this.data.put(node.key, (Object)node);
        } else if (this.sizeIn > this.maxIn) {
            Node n = this.headIn.next;
            n.remove();
            --this.sizeIn;
            n.appendToTail(this.headOut);
            n.type = QueueType.OUT;
            ++this.sizeOut;
            if (this.sizeOut > this.maxOut) {
                this.policyStats.recordEviction();
                Node victim = this.headOut.next;
                this.data.remove(victim.key);
                victim.remove();
                --this.sizeOut;
            }
            this.data.put(node.key, (Object)node);
        } else {
            this.policyStats.recordEviction();
            Node victim = this.headMain.next;
            this.data.remove(victim.key);
            victim.remove();
            --this.sizeMain;
            this.data.put(node.key, (Object)node);
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static final class TwoQueueSettings
    extends BasicSettings {
        public TwoQueueSettings(Config config) {
            super(config);
        }

        public double percentIn() {
            return this.config().getDouble("two-queue.percent-in");
        }

        public double percentOut() {
            return this.config().getDouble("two-queue.percent-out");
        }
    }

    static final class Node {
        final long key;
        Node prev;
        Node next;
        @Nullable QueueType type;

        Node() {
            this.key = Long.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        Node(long key) {
            this.key = key;
            this.prev = UNLINKED;
            this.next = UNLINKED;
        }

        public void appendToTail(Node head) {
            Node tail = head.prev;
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void moveToTail(Node head) {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = head;
            this.prev = head.prev;
            head.prev = this;
            this.prev.next = this;
        }

        public void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = this.next = UNLINKED;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("type", (Object)this.type).toString();
        }
    }

    static enum QueueType {
        MAIN,
        IN,
        OUT;

    }
}

