/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.two_queue;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@Policy.PolicySpec(name="two-queue.TuQueue")
public class TuQueuePolicy
implements Policy.KeyOnlyPolicy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final int maximumSize;
    private int sizeHot;
    private final int maxHot;
    private final Node headHot;
    private int sizeWarm;
    private final int maxWarm;
    private final Node headWarm;
    private int sizeCold;
    private final Node headCold;

    public TuQueuePolicy(Config config) {
        TuQueueSettings settings = new TuQueueSettings(config);
        this.headHot = new Node();
        this.headWarm = new Node();
        this.headCold = new Node();
        this.data = new Long2ObjectOpenHashMap();
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        this.maximumSize = Math.toIntExact(settings.maximumSize());
        this.maxHot = (int)((double)this.maximumSize * settings.percentHot());
        this.maxWarm = (int)((double)this.maximumSize * settings.percentWarm());
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        if (node == null) {
            this.policyStats.recordMiss();
            this.onMiss(key);
        } else {
            this.policyStats.recordHit();
            this.onHit(node);
        }
    }

    private void onHit(Node node) {
        if (node.type == QueueType.HOT) {
            node.moveToTail(this.headHot);
        } else if (node.type == QueueType.WARM) {
            node.moveToTail(this.headWarm);
        } else if (node.type == QueueType.COLD) {
            node.remove();
            --this.sizeCold;
            node.type = QueueType.WARM;
            node.appendToTail(this.headWarm);
            ++this.sizeWarm;
            if (this.sizeWarm > this.maxWarm) {
                Node demoted = Objects.requireNonNull(this.headWarm.next);
                demoted.remove();
                --this.sizeWarm;
                demoted.type = QueueType.COLD;
                demoted.appendToTail(this.headCold);
                ++this.sizeCold;
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private void onMiss(long key) {
        Node node = new Node(key);
        node.type = QueueType.HOT;
        node.appendToTail(this.headHot);
        this.data.put(key, (Object)node);
        ++this.sizeHot;
        if (this.sizeHot > this.maxHot) {
            Node demoted = Objects.requireNonNull(this.headHot.next);
            demoted.remove();
            --this.sizeHot;
            demoted.appendToTail(this.headCold);
            demoted.type = QueueType.COLD;
            ++this.sizeCold;
            this.evict();
        }
    }

    private void evict() {
        if (this.data.size() > this.maximumSize) {
            Node victim = Objects.requireNonNull(this.headCold.next);
            this.data.remove(victim.key);
            victim.remove();
            --this.sizeCold;
            this.policyStats.recordEviction();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        Preconditions.checkState((this.sizeHot + this.sizeWarm + this.sizeCold == this.data.size() ? 1 : 0) != 0);
    }

    static final class TuQueueSettings
    extends BasicSettings {
        public TuQueueSettings(Config config) {
            super(config);
        }

        public double percentHot() {
            double percentHot = this.config().getDouble("tu-queue.percent-hot");
            Preconditions.checkState((percentHot < 1.0 ? 1 : 0) != 0);
            return percentHot;
        }

        public double percentWarm() {
            double percentWarm = this.config().getDouble("tu-queue.percent-warm");
            Preconditions.checkState((percentWarm < 1.0 ? 1 : 0) != 0);
            return percentWarm;
        }
    }

    static final class Node {
        final long key;
        @Nullable Node prev;
        @Nullable Node next;
        @Nullable QueueType type;

        Node() {
            this.key = Long.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        Node(long key) {
            this.key = key;
        }

        public void appendToTail(Node head) {
            Node tail = Objects.requireNonNull(head.prev);
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void moveToTail(Node head) {
            Objects.requireNonNull(this.prev);
            Objects.requireNonNull(this.next);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = head;
            this.prev = Objects.requireNonNull(head.prev);
            head.prev = this;
            this.prev.next = this;
        }

        public void remove() {
            Objects.requireNonNull(this.prev);
            Objects.requireNonNull(this.next);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = null;
            this.prev = null;
            this.type = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("type", (Object)this.type).toString();
        }
    }

    static enum QueueType {
        HOT,
        WARM,
        COLD;

    }
}

