/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.hill;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.AbstractClimber;
import com.typesafe.config.Config;
import java.util.Random;

public final class SimulatedAnnealingClimber
extends AbstractClimber {
    private final double coolDownTolerance;
    private final double restartTolerance;
    private final double minTemperature;
    private final double coolDownRate;
    private final int initialStepSize;
    private final Random random;
    private boolean increaseWindow;
    private double temperature;
    private int stepSize;

    public SimulatedAnnealingClimber(Config config) {
        SimulatedAnnealingSettings settings = new SimulatedAnnealingSettings(config);
        int maximumSize = Math.toIntExact(settings.maximumSize());
        this.initialStepSize = (int)(settings.percentPivot() * (double)maximumSize);
        this.sampleSize = (int)(settings.percentSample() * (double)maximumSize);
        this.coolDownTolerance = 100.0 * settings.coolDownTolerance();
        this.restartTolerance = 100.0 * settings.restartTolerance();
        this.random = new Random(settings.randomSeed());
        this.minTemperature = settings.minTemperature();
        this.coolDownRate = settings.coolDownRate();
        this.restart();
    }

    private void restart() {
        this.stepSize = this.initialStepSize;
        this.temperature = 1.0;
    }

    @Override
    protected double adjust(double hitRate) {
        if (this.previousHitRate - hitRate >= this.restartTolerance) {
            this.restart();
        }
        if (this.temperature <= this.minTemperature) {
            return 0.0;
        }
        double criteria = this.random.nextGaussian();
        double acceptanceProbability = Math.exp((hitRate - this.previousHitRate) / (100.0 * this.temperature));
        if (hitRate < this.previousHitRate && acceptanceProbability <= criteria) {
            this.increaseWindow = !this.increaseWindow;
            this.stepSize = Math.max(this.stepSize - 1, 0);
        }
        if (this.previousHitRate - hitRate > this.coolDownTolerance) {
            this.temperature = this.coolDownRate * this.temperature;
            this.stepSize = 1 + (int)((double)this.stepSize * this.temperature);
        }
        return this.increaseWindow ? (double)this.stepSize : (double)(-this.stepSize);
    }

    static final class SimulatedAnnealingSettings
    extends BasicSettings {
        static final String BASE_PATH = "hill-climber-window-tiny-lfu.simulated-annealing.";

        public SimulatedAnnealingSettings(Config config) {
            super(config);
        }

        public double percentPivot() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simulated-annealing.percent-pivot");
        }

        public double percentSample() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simulated-annealing.percent-sample");
        }

        public double coolDownRate() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simulated-annealing.cool-down-rate");
        }

        public double minTemperature() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simulated-annealing.min-temperature");
        }

        public double restartTolerance() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simulated-annealing.restart-tolerance");
        }

        public double coolDownTolerance() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simulated-annealing.cool-down-tolerance");
        }
    }
}

