/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.typesafe.config.Config;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;
import org.cache2k.event.CacheEntryEvictedListener;
import org.cache2k.event.CacheEntryOperationListener;

@Policy.PolicySpec(name="product.Cache2k", characteristics={Policy.Characteristic.WEIGHTED})
public final class Cache2kPolicy
implements Policy {
    private static final Logger logger = Logger.getLogger("org.cache2k");
    private final Cache<Long, AccessEvent> cache;
    private final PolicyStats policyStats;

    public Cache2kPolicy(Config config, Set<Policy.Characteristic> characteristics) {
        logger.setLevel(Level.WARNING);
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        BasicSettings settings = new BasicSettings(config);
        CacheEntryEvictedListener listener = (cache, entry) -> this.policyStats.recordEviction();
        Cache2kBuilder builder = Cache2kBuilder.of(Long.class, AccessEvent.class).addListener((CacheEntryOperationListener)listener).strictEviction(true);
        if (characteristics.contains((Object)Policy.Characteristic.WEIGHTED)) {
            builder.weigher((key, value) -> value.weight());
            builder.maximumWeight(settings.maximumSize());
        } else {
            builder.entryCapacity(settings.maximumSize());
        }
        this.cache = builder.build();
    }

    @Override
    public void record(AccessEvent event) {
        AccessEvent value = (AccessEvent)this.cache.peek((Object)event.key());
        if (value == null) {
            this.cache.put((Object)event.key(), (Object)event);
            this.policyStats.recordWeightedMiss(event.weight());
        } else {
            this.policyStats.recordWeightedHit(event.weight());
            if (event.weight() != value.weight()) {
                this.cache.put((Object)event.key(), (Object)event);
            }
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        this.cache.close();
    }
}

