/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.Synthetic;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceFormat;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyActor;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.policy.Registry;
import com.github.benmanes.caffeine.cache.simulator.report.Reporter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class Simulator {
    private final BasicSettings settings;

    public Simulator(Config config) {
        this.settings = new BasicSettings(config.getConfig("caffeine.simulator"));
    }

    public void run() {
        TraceReader trace = Simulator.getTraceReader(this.settings);
        ImmutableList<PolicyActor> policies = this.getPolicyActors(trace.characteristics());
        if (policies.isEmpty()) {
            System.err.println("No active policies in the current configuration");
            return;
        }
        try {
            this.broadcast(trace, (List<PolicyActor>)policies);
            this.report(trace, (List<PolicyActor>)policies);
        }
        catch (RuntimeException e) {
            Simulator.throwError(e, policies);
        }
    }

    private void broadcast(TraceReader trace, List<PolicyActor> policies) {
        long skip = this.settings.trace().skip();
        long limit = this.settings.trace().limit();
        int batchSize = this.settings.actor().batchSize();
        try (Stream<AccessEvent> events = trace.events().skip(skip).limit(limit);){
            ArrayList batch = new ArrayList(batchSize);
            events.forEach(event -> {
                batch.add(event);
                if (batch.size() == batchSize) {
                    ImmutableList accessEvents = ImmutableList.copyOf((Collection)batch);
                    for (PolicyActor policy : policies) {
                        policy.send((ImmutableList<AccessEvent>)accessEvents);
                    }
                    batch.clear();
                }
            });
            ImmutableList remainder = ImmutableList.copyOf(batch);
            for (PolicyActor policy : policies) {
                policy.send((ImmutableList<AccessEvent>)remainder);
                policy.finish();
            }
            CompletableFuture[] futures = (CompletableFuture[])policies.stream().map(PolicyActor::completed).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(futures).join();
        }
    }

    private void report(TraceReader trace, List<PolicyActor> policies) {
        Reporter reporter = this.settings.report().format().create(this.settings.config(), trace.characteristics());
        ImmutableList results = (ImmutableList)policies.stream().map(PolicyActor::stats).collect(ImmutableList.toImmutableList());
        reporter.print((List<PolicyStats>)results);
    }

    private static TraceReader getTraceReader(BasicSettings settings) {
        if (settings.trace().isSynthetic()) {
            return Synthetic.generate(settings.trace());
        }
        List<String> filePaths = settings.trace().traceFiles().paths();
        TraceFormat format = settings.trace().traceFiles().format();
        return format.readFiles(filePaths);
    }

    private ImmutableList<PolicyActor> getPolicyActors(Set<Policy.Characteristic> characteristics) {
        Registry registry = new Registry(this.settings, characteristics);
        return (ImmutableList)registry.policies().stream().map(policy -> new PolicyActor(Thread.currentThread(), (Policy)policy, this.settings)).collect(ImmutableList.toImmutableList());
    }

    private static void throwError(RuntimeException error, Iterable<PolicyActor> policies) {
        if (!Thread.currentThread().isInterrupted()) {
            throw error;
        }
        for (PolicyActor policy : policies) {
            if (!policy.completed().isCompletedExceptionally()) continue;
            try {
                policy.completed().join();
            }
            catch (CompletionException e) {
                if (e.getCause() != null) {
                    Throwables.throwIfUnchecked((Throwable)e.getCause());
                }
                e.addSuppressed(error);
                throw e;
            }
        }
        throw error;
    }

    public static void main(String[] args) {
        Logger.getLogger("").setLevel(Level.WARNING);
        Simulator simulator = new Simulator(ConfigFactory.load());
        Stopwatch stopwatch = Stopwatch.createStarted();
        simulator.run();
        System.out.printf(Locale.US, "Executed in %s%n", stopwatch);
    }
}

