/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.greedy_dual;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;

@Policy.PolicySpec(name="greedy-dual.Gdsf", characteristics={Policy.Characteristic.WEIGHTED})
public final class GdsfPolicy
implements Policy {
    private final NavigableSet<Node> priorityQueue;
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final long maximumSize;
    double clock;
    long size;

    public GdsfPolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        this.data = new Long2ObjectOpenHashMap();
        this.maximumSize = settings.maximumSize();
        this.priorityQueue = new TreeSet<Node>();
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void record(AccessEvent event) {
        Node node = (Node)this.data.get(event.key());
        if (node == null) {
            this.policyStats.recordWeightedMiss(event.weight());
            this.onMiss(event);
        } else {
            this.policyStats.recordWeightedHit(event.weight());
            this.onHit(event, node);
            this.size += (long)(event.weight() - node.weight);
            node.weight = event.weight();
            if (this.size > this.maximumSize) {
                this.evict(node);
            }
        }
    }

    private void onHit(AccessEvent event, Node node) {
        Preconditions.checkState((boolean)this.priorityQueue.remove(node), (String)"%s not found in priority queue", (long)node.key);
        ++node.frequency;
        node.priority = this.priorityOf(event, node.frequency);
        this.priorityQueue.add(node);
    }

    private double priorityOf(AccessEvent event, int frequency) {
        double cost = event.isPenaltyAware() ? event.missPenalty() : 1.0;
        return this.clock + (double)frequency * (cost / (double)event.weight());
    }

    private void onMiss(AccessEvent event) {
        Node candidate = new Node(event.key(), event.weight(), this.priorityOf(event, 1));
        this.data.put(candidate.key, (Object)candidate);
        this.priorityQueue.add(candidate);
        this.size += (long)candidate.weight;
        if (this.size <= this.maximumSize) {
            this.policyStats.recordAdmission();
        } else {
            this.evict(candidate);
        }
    }

    private void evict(Node candidate) {
        Set<Node> victims = this.getVictims(this.size - this.maximumSize);
        if (victims.contains(candidate)) {
            this.policyStats.recordRejection();
            this.remove(candidate);
        } else {
            this.policyStats.recordAdmission();
            for (Node victim : victims) {
                if (victim.priority > this.clock) {
                    this.clock = victim.priority;
                }
                this.remove(victim);
            }
        }
        Preconditions.checkState((this.size <= this.maximumSize ? 1 : 0) != 0);
    }

    private Set<Node> getVictims(long weightDifference) {
        long weightedSize = 0L;
        LinkedHashSet<Node> victims = new LinkedHashSet<Node>();
        for (Node node : this.priorityQueue) {
            victims.add(node);
            if ((weightedSize += (long)node.weight) < weightDifference) continue;
            break;
        }
        return victims;
    }

    private void remove(Node node) {
        this.policyStats.recordEviction();
        this.priorityQueue.remove(node);
        this.data.remove(node.key);
        this.size -= (long)node.weight;
    }

    @Override
    public void finished() {
        Preconditions.checkState((this.size <= this.maximumSize ? 1 : 0) != 0, (String)"%s > %s", (long)this.size, (long)this.maximumSize);
        long weightedSize = this.data.values().stream().mapToLong(node -> node.weight).sum();
        Preconditions.checkState((weightedSize == this.size ? 1 : 0) != 0, (String)"%s != %s", (long)weightedSize, (long)this.size);
        Preconditions.checkState((this.priorityQueue.size() == this.data.size() ? 1 : 0) != 0, (String)"%s != %s", (int)this.priorityQueue.size(), (int)this.data.size());
        Preconditions.checkState((boolean)this.priorityQueue.containsAll((Collection<?>)this.data.values()), (Object)"Data != PriorityQueue");
    }

    private static final class Node
    implements Comparable<Node> {
        final long key;
        double priority;
        int frequency;
        int weight;

        public Node(long key, int weight, double priority) {
            this.priority = priority;
            this.weight = weight;
            this.frequency = 1;
            this.key = key;
        }

        @Override
        public int compareTo(Node node) {
            int result = Double.compare(this.priority, node.priority);
            return result == 0 ? Long.compare(this.key, node.key) : result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node node = (Node)o;
            return this.key == node.key && this.priority == node.priority;
        }

        public int hashCode() {
            return Long.hashCode(this.key);
        }

        public String toString() {
            return MoreObjects.toStringHelper(Node.class).add("key", this.key).add("weight", this.weight).add("priority", this.priority).add("frequency", this.frequency).toString();
        }
    }
}

