/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.segment;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.admission.TinyLfu;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Policy.PolicySpec(name="sketch.FullySegmentedWindowTinyLfu")
public final class FullySegmentedWindowTinyLfuPolicy
implements Policy.KeyOnlyPolicy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final Admittor admittor;
    private final int maximumSize;
    private final Node headWindowProbation;
    private final Node headWindowProtected;
    private final Node headMainProbation;
    private final Node headMainProtected;
    private final int maxWindow;
    private final int maxWindowProtected;
    private final int maxMainProtected;
    private int sizeWindow;
    private int sizeWindowProtected;
    private int sizeMainProtected;

    public FullySegmentedWindowTinyLfuPolicy(double percentMain, FullySegmentedWindowTinyLfuSettings settings) {
        this.policyStats = new PolicyStats(this.name() + " (%.0f%%)", 100.0 * (1.0 - percentMain));
        this.maximumSize = Math.toIntExact(settings.maximumSize());
        int maxMain = (int)((double)this.maximumSize * percentMain);
        this.maxWindow = this.maximumSize - maxMain;
        this.maxMainProtected = (int)((double)maxMain * settings.percentMainProtected());
        this.maxWindowProtected = (int)((double)this.maxWindow * settings.percentWindowProtected());
        this.admittor = new TinyLfu(settings.config(), this.policyStats);
        this.data = new Long2ObjectOpenHashMap();
        this.headWindowProbation = new Node();
        this.headWindowProtected = new Node();
        this.headMainProbation = new Node();
        this.headMainProtected = new Node();
    }

    public static Set<Policy> policies(Config config) {
        FullySegmentedWindowTinyLfuSettings settings = new FullySegmentedWindowTinyLfuSettings(config);
        return settings.percentMain().stream().map(percentMain -> new FullySegmentedWindowTinyLfuPolicy((double)percentMain, settings)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        this.admittor.record(key);
        if (node == null) {
            this.onMiss(key);
            this.policyStats.recordMiss();
        } else if (node.status == Status.WINDOW_PROBATION) {
            this.onWindowProbationHit(node);
            this.policyStats.recordHit();
        } else if (node.status == Status.WINDOW_PROTECTED) {
            this.onWindowProtectedHit(node);
            this.policyStats.recordHit();
        } else if (node.status == Status.MAIN_PROBATION) {
            this.onMainProbationHit(node);
            this.policyStats.recordHit();
        } else if (node.status == Status.MAIN_PROTECTED) {
            this.onMainProtectedHit(node);
            this.policyStats.recordHit();
        } else {
            throw new IllegalStateException();
        }
    }

    private void onMiss(long key) {
        Node node = new Node(key, Status.WINDOW_PROBATION);
        node.appendToTail(this.headWindowProbation);
        this.data.put(key, (Object)node);
        ++this.sizeWindow;
        this.evict();
    }

    private void onWindowProbationHit(Node node) {
        node.remove();
        node.status = Status.WINDOW_PROTECTED;
        node.appendToTail(this.headWindowProtected);
        ++this.sizeWindowProtected;
        if (this.sizeWindowProtected > this.maxWindowProtected) {
            Node demote = this.headWindowProtected.next;
            demote.remove();
            demote.status = Status.WINDOW_PROBATION;
            demote.appendToTail(this.headWindowProbation);
            --this.sizeWindowProtected;
        }
    }

    private void onWindowProtectedHit(Node node) {
        node.moveToTail(this.headWindowProtected);
    }

    private void onMainProbationHit(Node node) {
        node.remove();
        node.status = Status.MAIN_PROTECTED;
        node.appendToTail(this.headMainProtected);
        ++this.sizeMainProtected;
        if (this.sizeMainProtected > this.maxMainProtected) {
            Node demote = this.headMainProtected.next;
            demote.remove();
            demote.status = Status.MAIN_PROBATION;
            demote.appendToTail(this.headMainProbation);
            --this.sizeMainProtected;
        }
    }

    private void onMainProtectedHit(Node node) {
        node.moveToTail(this.headMainProtected);
    }

    private void evict() {
        if (this.sizeWindow <= this.maxWindow) {
            return;
        }
        Node candidate = this.headWindowProbation.next;
        --this.sizeWindow;
        candidate.remove();
        candidate.status = Status.MAIN_PROBATION;
        candidate.appendToTail(this.headMainProbation);
        if (this.data.size() > this.maximumSize) {
            Node victim = this.headMainProbation.next;
            Node evict = this.admittor.admit(candidate.key, victim.key) ? victim : candidate;
            this.data.remove(evict.key);
            evict.remove();
            this.policyStats.recordEviction();
        }
    }

    @Override
    public void finished() {
        long windowProbationSize = this.data.values().stream().filter(n -> n.status == Status.WINDOW_PROBATION).count();
        long windowProtectedSize = this.data.values().stream().filter(n -> n.status == Status.WINDOW_PROTECTED).count();
        long mainProtectedSize = this.data.values().stream().filter(n -> n.status == Status.MAIN_PROTECTED).count();
        Preconditions.checkState((this.sizeWindow <= this.maxWindow ? 1 : 0) != 0);
        Preconditions.checkState((windowProtectedSize == (long)this.sizeWindowProtected ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.sizeWindow == windowProbationSize + (long)this.sizeWindowProtected ? 1 : 0) != 0);
        Preconditions.checkState((mainProtectedSize == (long)this.sizeMainProtected ? 1 : 0) != 0);
        Preconditions.checkState((this.data.size() <= this.maximumSize ? 1 : 0) != 0);
    }

    static final class FullySegmentedWindowTinyLfuSettings
    extends BasicSettings {
        public FullySegmentedWindowTinyLfuSettings(Config config) {
            super(config);
        }

        public List<Double> percentMain() {
            return this.config().getDoubleList("fully-segmented-window-tiny-lfu.percent-main");
        }

        public double percentMainProtected() {
            return this.config().getDouble("fully-segmented-window-tiny-lfu.percent-main-protected");
        }

        public double percentWindowProtected() {
            return this.config().getDouble("fully-segmented-window-tiny-lfu.percent-window-protected");
        }
    }

    static final class Node {
        final long key;
        Status status;
        Node prev;
        Node next;

        public Node() {
            this.key = Integer.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        public Node(long key, Status status) {
            this.status = status;
            this.key = key;
        }

        public void moveToTail(Node head) {
            this.remove();
            this.appendToTail(head);
        }

        public void appendToTail(Node head) {
            Node tail = head.prev;
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = null;
            this.next = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("status", (Object)this.status).toString();
        }
    }

    static enum Status {
        WINDOW_PROBATION,
        WINDOW_PROTECTED,
        MAIN_PROBATION,
        MAIN_PROTECTED;

    }
}

