/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import java.util.Locale;
import java.util.stream.LongStream;
import site.ycsb.generator.CounterGenerator;
import site.ycsb.generator.ExponentialGenerator;
import site.ycsb.generator.HotspotIntegerGenerator;
import site.ycsb.generator.NumberGenerator;
import site.ycsb.generator.ScrambledZipfianGenerator;
import site.ycsb.generator.SequentialGenerator;
import site.ycsb.generator.SkewedLatestGenerator;
import site.ycsb.generator.UniformLongGenerator;
import site.ycsb.generator.ZipfianGenerator;

public final class Synthetic {
    private Synthetic() {
    }

    public static TraceReader.KeyOnlyTraceReader generate(BasicSettings.TraceSettings settings) {
        int events = settings.synthetic().events();
        switch (settings.synthetic().distribution().toLowerCase(Locale.US)) {
            case "counter": {
                return () -> Synthetic.counter(settings.synthetic().counter().start(), events);
            }
            case "repeating": {
                return () -> Synthetic.repeating(settings.synthetic().repeating().items(), events);
            }
            case "uniform": {
                BasicSettings.SyntheticSettings.UniformSettings uniform = settings.synthetic().uniform();
                return () -> Synthetic.uniform(uniform.lowerBound(), uniform.upperBound(), events);
            }
            case "exponential": {
                return () -> Synthetic.exponential(settings.synthetic().exponential().mean(), events);
            }
            case "hotspot": {
                BasicSettings.SyntheticSettings.HotspotSettings hotspot = settings.synthetic().hotspot();
                return () -> Synthetic.hotspot(hotspot.lowerBound(), hotspot.upperBound(), hotspot.hotOpnFraction(), hotspot.hotsetFraction(), events);
            }
            case "zipfian": {
                return () -> Synthetic.zipfian(settings.synthetic().zipfian().items(), settings.synthetic().zipfian().constant(), events);
            }
            case "scrambled-zipfian": {
                return () -> Synthetic.scrambledZipfian(settings.synthetic().zipfian().items(), settings.synthetic().zipfian().constant(), events);
            }
            case "skewed-zipfian-latest": {
                return () -> Synthetic.skewedZipfianLatest(settings.synthetic().zipfian().items(), events);
            }
        }
        throw new IllegalStateException("Unknown distribution: " + settings.synthetic().distribution());
    }

    public static LongStream counter(int start, int events) {
        return Synthetic.generate((NumberGenerator)new CounterGenerator((long)start), events);
    }

    public static LongStream repeating(int items, int events) {
        return Synthetic.generate((NumberGenerator)new SequentialGenerator(0L, (long)items), events);
    }

    public static LongStream uniform(int lowerBound, int upperBound, int events) {
        return Synthetic.generate((NumberGenerator)new UniformLongGenerator((long)lowerBound, (long)upperBound), events);
    }

    public static LongStream exponential(double mean, int events) {
        return Synthetic.generate((NumberGenerator)new ExponentialGenerator(mean), events);
    }

    public static LongStream hotspot(int lowerBound, int upperBound, double hotsetFraction, double hotOpnFraction, int events) {
        return Synthetic.generate((NumberGenerator)new HotspotIntegerGenerator((long)lowerBound, (long)upperBound, hotsetFraction, hotOpnFraction), events);
    }

    public static LongStream scrambledZipfian(int items, double constant, int events) {
        return Synthetic.generate((NumberGenerator)new ScrambledZipfianGenerator(0L, (long)(items - 1), constant), events);
    }

    public static LongStream skewedZipfianLatest(int items, int events) {
        return Synthetic.generate((NumberGenerator)new SkewedLatestGenerator(new CounterGenerator((long)items)), events);
    }

    public static LongStream zipfian(int items, double constant, int events) {
        return Synthetic.generate((NumberGenerator)new ZipfianGenerator((long)items, constant), events);
    }

    private static LongStream generate(NumberGenerator generator, long count) {
        return LongStream.range(0L, count).map(ignored -> ((Number)generator.nextValue()).longValue());
    }
}

