/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report.csv;

import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.report.Metrics;
import com.github.benmanes.caffeine.cache.simulator.report.TextReporter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.typesafe.config.Config;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class CsvReporter
extends TextReporter {
    public CsvReporter(Config config, Set<Policy.Characteristic> characteristics) {
        super(config, characteristics);
    }

    @Override
    protected String assemble(List<PolicyStats> results) {
        StringWriter output = new StringWriter();
        CsvWriter writer = new CsvWriter((Writer)output, new CsvWriterSettings());
        writer.writeHeaders(this.headers());
        for (PolicyStats policyStats : results) {
            String[] data = (String[])this.headers().stream().map(policyStats.metrics()::get).map(this.metrics()::format).map(Strings::emptyToNull).toArray(String[]::new);
            writer.writeRow(data);
        }
        writer.close();
        return output.toString();
    }

    @Override
    protected Metrics newMetrics() {
        return Metrics.builder().percentFormatter(value -> String.format("%.2f", 100.0 * value)).doubleFormatter(value -> String.format("%.2f", value)).longFormatter(value -> String.format("%d", value)).objectFormatter(object -> object instanceof Stopwatch ? Long.toString(((Stopwatch)object).elapsed(TimeUnit.MILLISECONDS)) : object.toString()).build();
    }
}

