/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.twitter;

import com.github.benmanes.caffeine.cache.simulator.parser.TextTraceReader;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import java.util.Set;
import java.util.stream.Stream;

public final class TwitterTraceReader
extends TextTraceReader {
    public TwitterTraceReader(String filePath) {
        super(filePath);
    }

    @Override
    public Set<Policy.Characteristic> characteristics() {
        return Sets.immutableEnumSet((Enum)Policy.Characteristic.WEIGHTED, (Enum[])new Policy.Characteristic[0]);
    }

    @Override
    public Stream<AccessEvent> events() {
        return this.lines().map(line -> line.split(",")).filter(array -> {
            String operation = array[5];
            return operation.equals("get") || operation.equals("gets");
        }).map(array -> {
            long key = Hashing.murmur3_128().hashUnencodedChars((CharSequence)array[1]).asLong();
            int weight = Integer.parseInt(array[2]) + Integer.parseInt(array[3]);
            return AccessEvent.forKeyAndWeight(key, weight);
        });
    }
}

