/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.climb;

import com.github.benmanes.caffeine.cache.simulator.parser.TextTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.PrimitiveIterator;
import java.util.Scanner;
import java.util.Spliterators;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;

public final class ClimbTraceReader
extends TextTraceReader
implements TraceReader.KeyOnlyTraceReader {
    public ClimbTraceReader(String filePath) {
        super(filePath);
    }

    @Override
    public LongStream keys() {
        TraceIterator iterator = new TraceIterator(this.readFile());
        return (LongStream)StreamSupport.longStream(Spliterators.spliteratorUnknownSize(iterator, 16), false).onClose(iterator::close);
    }

    private static final class TraceIterator
    implements PrimitiveIterator.OfLong {
        private final Scanner scanner;

        TraceIterator(InputStream input) {
            this.scanner = new Scanner(input, StandardCharsets.UTF_8.name());
        }

        @Override
        public boolean hasNext() {
            return this.scanner.hasNextLong();
        }

        @Override
        public long nextLong() {
            return this.scanner.nextLong();
        }

        public void close() {
            this.scanner.close();
        }
    }
}

