/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy;

import akka.actor.AbstractActor;
import akka.dispatch.BoundedMessageQueueSemantics;
import akka.dispatch.RequiresMessageQueue;
import com.github.benmanes.caffeine.cache.simulator.Simulator;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Objects;

public final class PolicyActor
extends AbstractActor
implements RequiresMessageQueue<BoundedMessageQueueSemantics> {
    private final Policy policy;

    public PolicyActor(Policy policy) {
        this.policy = Objects.requireNonNull(policy);
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(LongArrayList.class, this::process).matchEquals((Object)Simulator.Message.FINISH, msg -> this.finish()).build();
    }

    private void process(LongArrayList events) {
        try {
            this.policy.stats().stopwatch().start();
            for (int i = 0; i < events.size(); ++i) {
                this.policy.record(events.getLong(i));
            }
        }
        catch (Exception e) {
            this.sender().tell((Object)Simulator.Message.ERROR, this.self());
            this.context().system().log().error((Throwable)e, "");
        }
        finally {
            this.policy.stats().stopwatch().stop();
        }
    }

    private void finish() {
        try {
            this.policy.finished();
            this.sender().tell((Object)this.policy.stats(), this.self());
        }
        catch (Exception e) {
            this.sender().tell((Object)Simulator.Message.ERROR, this.self());
            this.context().system().log().error((Throwable)e, "");
        }
    }
}

