/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.HillClimber;
import com.typesafe.config.Config;
import java.util.Random;

final class SimulatedAnnealingClimber
implements HillClimber {
    private final Random random;
    private int pivot;
    private final int initialPivot;
    private int sample;
    private final int sampleSize;
    private int hitsInSample;
    private int missesInSample;
    private double previousHitRate;
    private boolean increaseWindow;
    private double temperature = 1.0;
    private final double coolDownRate;
    private final double minTemperature;
    private final double restartTolerance;
    private final double coolDownTolerance;

    public SimulatedAnnealingClimber(Config config) {
        SimulatedAnnealingSettings settings = new SimulatedAnnealingSettings(config);
        this.random = new Random(settings.randomSeed());
        this.initialPivot = (int)(settings.percentPivot() * (double)settings.maximumSize());
        this.sampleSize = (int)(settings.percentSample() * (double)settings.maximumSize());
        this.pivot = this.initialPivot;
        this.coolDownRate = settings.coolDownRate();
        this.minTemperature = settings.minTemperature();
        this.restartTolerance = 100.0 * settings.restartTolerance();
        this.coolDownTolerance = 100.0 * settings.coolDownTolerance();
    }

    @Override
    public void onMiss(long key) {
        ++this.missesInSample;
        ++this.sample;
    }

    @Override
    public void onHit(long key, HillClimber.QueueType queueType) {
        ++this.hitsInSample;
        ++this.sample;
    }

    @Override
    public HillClimber.Adaptation adapt(int windowSize, int protectedSize) {
        HillClimber.Adaptation adaption = HillClimber.Adaptation.HOLD;
        if (this.sample >= this.sampleSize) {
            double hitRate = 100.0 * (double)this.hitsInSample / (double)(this.hitsInSample + this.missesInSample);
            if (!Double.isNaN(hitRate) && !Double.isInfinite(hitRate) && this.previousHitRate != 0.0) {
                adaption = this.adjust(hitRate);
            }
            this.previousHitRate = hitRate;
            this.missesInSample = 0;
            this.hitsInSample = 0;
            this.sample = 0;
        }
        return adaption;
    }

    private HillClimber.Adaptation adjust(double hitRate) {
        if (this.previousHitRate - hitRate >= this.restartTolerance) {
            this.pivot = this.initialPivot;
            this.temperature = 1.0;
        }
        HillClimber.Adaptation.Type adaptionType = HillClimber.Adaptation.Type.HOLD;
        if (this.temperature > this.minTemperature) {
            double acceptanceProbability = Math.exp((hitRate - this.previousHitRate) / (100.0 * this.temperature));
            double criteria = this.random.nextGaussian();
            if (hitRate < this.previousHitRate && acceptanceProbability <= criteria) {
                this.increaseWindow = !this.increaseWindow;
                --this.pivot;
            }
            if (this.previousHitRate - hitRate > this.coolDownTolerance) {
                this.temperature = this.coolDownRate * this.temperature;
                this.pivot = 1 + (int)((double)this.pivot * this.temperature);
            }
            adaptionType = this.increaseWindow ? HillClimber.Adaptation.Type.INCREASE_WINDOW : HillClimber.Adaptation.Type.DECREASE_WINDOW;
        }
        return new HillClimber.Adaptation(adaptionType, this.pivot);
    }

    static final class SimulatedAnnealingSettings
    extends BasicSettings {
        static final String BASE_PATH = "hill-climber-window-tiny-lfu.simulated-annealing.";

        public SimulatedAnnealingSettings(Config config) {
            super(config);
        }

        public double percentPivot() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simulated-annealing.percent-pivot");
        }

        public double percentSample() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simulated-annealing.percent-sample");
        }

        public double coolDownRate() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simulated-annealing.cool-down-rate");
        }

        public double minTemperature() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simulated-annealing.min-temperature");
        }

        public double restartTolerance() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simulated-annealing.restart-tolerance");
        }

        public double coolDownTolerance() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simulated-annealing.cool-down-tolerance");
        }
    }
}

