/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.HillClimber;
import com.typesafe.config.Config;

final class SimpleClimber
implements HillClimber {
    private final int pivot;
    private int sample;
    private final int sampleSize;
    private int hitsInSample;
    private int missesInSample;
    private double previousHitRate;
    private final double tolerance;
    private boolean increaseWindow;

    public SimpleClimber(Config config) {
        SimpleClimberSettings settings = new SimpleClimberSettings(config);
        this.sampleSize = (int)(settings.percentSample() * (double)settings.maximumSize());
        this.pivot = (int)(settings.percentPivot() * (double)settings.maximumSize());
        this.tolerance = 100.0 * settings.tolerance();
    }

    @Override
    public void onMiss(long key) {
        ++this.missesInSample;
        ++this.sample;
    }

    @Override
    public void onHit(long key, HillClimber.QueueType queueType) {
        ++this.hitsInSample;
        ++this.sample;
    }

    @Override
    public HillClimber.Adaptation adapt(int windowSize, int protectedSize) {
        HillClimber.Adaptation adaption = HillClimber.Adaptation.HOLD;
        if (this.sample >= this.sampleSize) {
            double hitRate = 100.0 * (double)this.hitsInSample / (double)(this.hitsInSample + this.missesInSample);
            if (!Double.isNaN(hitRate) && !Double.isInfinite(hitRate) && this.previousHitRate != 0.0) {
                adaption = this.adjust(hitRate);
            }
            this.previousHitRate = hitRate;
            this.missesInSample = 0;
            this.hitsInSample = 0;
            this.sample = 0;
        }
        return adaption;
    }

    private HillClimber.Adaptation adjust(double hitRate) {
        if (hitRate < this.previousHitRate + this.tolerance) {
            this.increaseWindow = !this.increaseWindow;
        }
        HillClimber.Adaptation.Type adaptionType = this.increaseWindow ? HillClimber.Adaptation.Type.INCREASE_WINDOW : HillClimber.Adaptation.Type.DECREASE_WINDOW;
        return new HillClimber.Adaptation(adaptionType, this.pivot);
    }

    static final class SimpleClimberSettings
    extends BasicSettings {
        static final String BASE_PATH = "hill-climber-window-tiny-lfu.simple.";

        public SimpleClimberSettings(Config config) {
            super(config);
        }

        public double percentPivot() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simple.percent-pivot");
        }

        public double percentSample() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simple.percent-sample");
        }

        public double tolerance() {
            return this.config().getInt("hill-climber-window-tiny-lfu.simple.tolerance");
        }
    }
}

