/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.greedy_dual;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@Policy.PolicySpec(name="greedy-dual.GDWheel", characteristics={Policy.Characteristic.WEIGHTED})
public final class GDWheelPolicy
implements Policy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final Sentinel[][] wheel;
    private final long maximumSize;
    private final int[] clockHand;
    private final double[] cost;
    private int size;

    public GDWheelPolicy(Config config) {
        GDWheelSettings settings = new GDWheelSettings(config);
        this.maximumSize = settings.maximumSize();
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        this.data = new Long2ObjectOpenHashMap();
        this.cost = new double[settings.numberOfWheels()];
        this.clockHand = new int[settings.numberOfWheels()];
        this.wheel = new Sentinel[settings.numberOfWheels()][settings.numberOfQueues()];
        for (int i = 0; i < settings.numberOfWheels(); ++i) {
            for (int j = 0; j < settings.numberOfQueues(); ++j) {
                this.wheel[i][j] = new Sentinel(i, j);
            }
            this.cost[i] = Math.pow(settings.numberOfQueues(), i);
        }
    }

    @Override
    public void record(AccessEvent event) {
        Node node = (Node)this.data.get(event.key());
        this.policyStats.recordOperation();
        if (node == null) {
            this.policyStats.recordWeightedMiss(event.weight());
            node = new Node(event.key());
            this.onMiss(event, node);
        } else {
            this.policyStats.recordWeightedHit(event.weight());
            this.onHit(event, node);
        }
    }

    private void onMiss(AccessEvent event, Node node) {
        if ((long)event.weight() > this.maximumSize) {
            this.policyStats.recordEviction();
        } else {
            this.evict(event);
            this.add(event, node);
        }
    }

    private void evict(AccessEvent event) {
        while ((long)(this.size + event.weight()) > this.maximumSize) {
            int hand = this.findNextQueue();
            if (hand >= 0) {
                Node victim = Objects.requireNonNull(this.wheel[0][hand].prev);
                this.policyStats.recordEviction();
                this.remove(victim);
                continue;
            }
            this.migrate(1);
        }
    }

    private int findNextQueue() {
        for (int i = 0; i < this.wheel[0].length; ++i) {
            int index = (this.clockHand[0] + i) % this.wheel[0].length;
            if (this.wheel[0][index].isEmpty()) continue;
            return index;
        }
        return -1;
    }

    private void migrate(int level) {
        int hand;
        this.clockHand[level] = hand = (this.clockHand[level] + 1) % this.wheel[level].length;
        if (hand == 0 && level + 1 < this.wheel.length) {
            this.migrate(level + 1);
        }
        for (int i = 0; i < this.wheel[level].length; ++i) {
            Sentinel sentinel = this.wheel[level][hand];
            if (sentinel.isEmpty()) continue;
            Node node = Objects.requireNonNull(sentinel.next);
            node.remove();
            double remainder = node.cost % this.cost[level];
            int index = (int)((Math.round(remainder / this.cost[level - 1]) + (long)hand) % (long)this.wheel[level].length);
            this.wheel[level - 1][index].appendToHead(node);
        }
    }

    private void onHit(AccessEvent event, Node node) {
        this.remove(node);
        this.onMiss(event, node);
    }

    private void remove(Node node) {
        this.data.remove(node.key);
        this.size -= node.weight;
        node.remove();
    }

    private void add(AccessEvent event, Node node) {
        int wheelHand = 0;
        int wheelIndex = 0;
        long relativeCost = 0L;
        for (int i = 0; i < this.wheel.length; ++i) {
            long penalty = Math.round(event.missPenalty() / this.cost[i]);
            if (penalty <= 0L) continue;
            wheelHand = this.clockHand[i];
            relativeCost = penalty;
            wheelIndex = i;
        }
        int queueIndex = (int)((relativeCost + (long)wheelHand) % (long)this.wheel.length);
        Sentinel sentinel = this.wheel[wheelIndex][queueIndex];
        node.cost = event.missPenalty();
        node.weight = event.weight();
        sentinel.appendToHead(node);
        this.data.put(event.key(), (Object)node);
        this.size += event.weight();
    }

    @Override
    public void finished() {
        int expectedSize = this.data.values().stream().mapToInt(node -> node.weight).sum();
        Preconditions.checkState(((long)this.data.size() <= this.maximumSize ? 1 : 0) != 0, (String)"%s > %s", (int)this.data.size(), (long)this.maximumSize);
        Preconditions.checkState((this.size == expectedSize ? 1 : 0) != 0, (String)"%s != %s", (int)this.size, (int)expectedSize);
        int nodes = 0;
        Sentinel[][] sentinelArray = this.wheel;
        int n = sentinelArray.length;
        for (int i = 0; i < n; ++i) {
            Sentinel[] costWheel;
            for (Sentinel sentinel : costWheel = sentinelArray[i]) {
                Node next = sentinel.next;
                while (next != sentinel) {
                    next = Objects.requireNonNull(next).next;
                    ++nodes;
                }
            }
        }
        Preconditions.checkState((nodes == this.data.size() ? 1 : 0) != 0, (String)"%s != %s", (int)this.size, (int)expectedSize);
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static final class GDWheelSettings
    extends BasicSettings {
        public GDWheelSettings(Config config) {
            super(config);
        }

        public int numberOfWheels() {
            return this.config().getInt("gd-wheel.wheels");
        }

        public int numberOfQueues() {
            return this.config().getInt("gd-wheel.queues");
        }
    }

    static final class Sentinel
    extends Node {
        final int wheelIndex;
        final int queueIndex;

        public Sentinel(int wheelIndex, int queueIndex) {
            super(Long.MIN_VALUE);
            this.wheelIndex = wheelIndex;
            this.queueIndex = queueIndex;
            this.prev = this.next = this;
        }

        public boolean isEmpty() {
            return this.next == this;
        }

        public void appendToHead(Node node) {
            Objects.requireNonNull(this.next);
            node.prev = this;
            node.next = this.next;
            this.next.prev = node;
            this.next = node;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("wheelIndex", this.wheelIndex).add("queueIndex", this.queueIndex).toString();
        }
    }

    static class Node {
        final long key;
        double cost;
        int weight;
        @Nullable Node prev;
        @Nullable Node next;

        public Node(long key) {
            this.key = key;
        }

        public void remove() {
            Preconditions.checkState((!(this instanceof Sentinel) ? 1 : 0) != 0);
            Objects.requireNonNull(this.prev);
            Objects.requireNonNull(this.next);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = null;
            this.prev = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("cost", this.cost).add("weight", this.weight).toString();
        }
    }
}

