/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser;

import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.jspecify.annotations.Nullable;
import org.tukaani.xz.XZInputStream;

public abstract class AbstractTraceReader
implements TraceReader {
    private static final int BUFFER_SIZE = 65536;
    protected final String filePath;

    protected AbstractTraceReader(String filePath) {
        this.filePath = filePath.trim();
    }

    protected BufferedInputStream readFile() {
        try {
            return this.readInput(this.openFile());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected BufferedInputStream readInput(InputStream input) {
        BufferedInputStream bufferedStream = null;
        try {
            bufferedStream = new BufferedInputStream(input, 65536);
            List<UnaryOperator> extractors = List.of(AbstractTraceReader::tryXz, AbstractTraceReader::tryCompressed, this::tryArchived);
            for (UnaryOperator extractor : extractors) {
                bufferedStream.mark(100);
                InputStream next = (InputStream)extractor.apply(bufferedStream);
                if (next == null) {
                    bufferedStream.reset();
                    continue;
                }
                if (next instanceof BufferedInputStream) {
                    BufferedInputStream buffered;
                    bufferedStream = buffered = (BufferedInputStream)next;
                    continue;
                }
                bufferedStream = new BufferedInputStream(next, 65536);
            }
            return bufferedStream;
        }
        catch (Throwable t) {
            try {
                if (bufferedStream != null) {
                    bufferedStream.close();
                }
            }
            catch (IOException e) {
                t.addSuppressed(e);
            }
            Throwables.throwIfUnchecked((Throwable)t);
            throw new IllegalStateException(t);
        }
    }

    private static @Nullable InputStream tryXz(InputStream input) {
        try {
            return new XZInputStream(input);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static @Nullable InputStream tryCompressed(InputStream input) {
        try {
            return new CompressorStreamFactory().createCompressorInputStream(input);
        }
        catch (CompressorException compressorException) {
            return null;
        }
    }

    private @Nullable InputStream tryArchived(InputStream input) {
        try {
            final ArchiveInputStream archive = new ArchiveStreamFactory().createArchiveInputStream(input);
            AbstractIterator<InputStream> entries = new AbstractIterator<InputStream>(this){
                final /* synthetic */ AbstractTraceReader this$0;
                {
                    AbstractTraceReader abstractTraceReader = this$0;
                    Objects.requireNonNull(abstractTraceReader);
                    this.this$0 = abstractTraceReader;
                }

                protected @Nullable InputStream computeNext() {
                    try {
                        return archive.getNextEntry() == null ? (InputStream)this.endOfData() : this.this$0.readInput(new FilterInputStream(this, (InputStream)archive){
                            {
                                Objects.requireNonNull(this$1);
                                super(arg0);
                            }

                            @Override
                            public void close() {
                                this.in = InputStream.nullInputStream();
                            }
                        });
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
            return new MultiInputStream((InputStream)archive, (Iterator<InputStream>)entries);
        }
        catch (ArchiveException archiveException) {
            return null;
        }
    }

    private InputStream openFile() throws IOException {
        Path file = Path.of(this.filePath, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            return Files.newInputStream(file, new OpenOption[0]);
        }
        InputStream input = this.getClass().getResourceAsStream(this.filePath);
        Preconditions.checkArgument((input != null ? 1 : 0) != 0, (String)"Could not find file: %s", (Object)this.filePath);
        return input;
    }

    private static final class MultiInputStream
    extends FilterInputStream {
        private final InputStream parent;

        MultiInputStream(InputStream parent, Iterator<InputStream> children) {
            super(new SequenceInputStream(Iterators.asEnumeration(children)));
            this.parent = parent;
        }

        @Override
        public void close() throws IOException {
            this.parent.close();
        }
    }
}

