/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.baleen;

import com.github.benmanes.caffeine.cache.simulator.parser.TextTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.google.common.math.IntMath;
import java.math.RoundingMode;
import java.util.stream.LongStream;

public final class BaleenTraceReader
extends TextTraceReader
implements TraceReader.KeyOnlyTraceReader {
    private static final int SEGMENT_SIZE = 131072;

    public BaleenTraceReader(String filePath) {
        super(filePath);
    }

    @Override
    public LongStream keys() {
        return this.lines().dropWhile(line -> line.startsWith("#")).map(line -> line.split(" ", 6)).filter(line -> BaleenTraceReader.isRead(line[4].charAt(0))).flatMapToLong(line -> {
            long block = Long.parseLong(line[0]);
            long byteOffset = Long.parseLong(line[1]);
            int size = Integer.parseInt(line[2]);
            int startSegment = Math.toIntExact(byteOffset / 131072L);
            int sequence = IntMath.divide((int)size, (int)131072, (RoundingMode)RoundingMode.UP);
            long startKey = (long)Long.hashCode(block) << 32 | (long)startSegment;
            return LongStream.range(startKey, startKey + (long)sequence);
        });
    }

    private static boolean isRead(char operation) {
        return operation == '1' || operation == '2' || operation == '5';
    }
}

