/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report.csv;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Doubles;
import de.siegmar.fastcsv.reader.CloseableIterator;
import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.NamedCsvRecord;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Objects;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public record PlotCsv(Path inputFile, Path outputFile, String metric, String title, ChartStyle style) implements Runnable
{
    public PlotCsv {
        Objects.requireNonNull(outputFile);
        Objects.requireNonNull(inputFile);
        Objects.requireNonNull(metric);
        Objects.requireNonNull(title);
        Objects.requireNonNull(style);
    }

    @Override
    public void run() {
        JFreeChart chart = ChartFactory.createLineChart((String)this.title, (String)"Maximum Size", (String)this.metric, (CategoryDataset)this.data());
        chart.setTextAntiAlias(true);
        chart.setAntiAlias(true);
        this.applyTheme(chart);
        this.configurePlot(chart);
        try {
            ChartUtils.saveChartAsPNG((File)this.outputFile.toFile(), (JFreeChart)chart, (int)1280, (int)720);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private CategoryDataset data() {
        CloseableIterator closeableIterator;
        block10: {
            CsvReader reader = CsvReader.builder().ofNamedCsvRecord(this.inputFile);
            try {
                DefaultCategoryDataset dataset = new DefaultCategoryDataset();
                for (NamedCsvRecord record : reader) {
                    for (String column : Iterables.skip((Iterable)record.getHeader(), (int)1)) {
                        Double value = record.findField(column).map(Doubles::tryParse).orElse(null);
                        dataset.addValue((Number)value, (Comparable)((Object)record.getField(0)), (Comparable)((Object)column));
                    }
                }
                closeableIterator = dataset;
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            reader.close();
        }
        return closeableIterator;
    }

    private void configurePlot(JFreeChart chart) {
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        this.configureAxis((Axis)plot.getDomainAxis());
        this.configureAxis((Axis)plot.getRangeAxis());
        this.configureGrid(plot);
        plot.getRangeAxis().setAutoRange(false);
        plot.getRangeAxis().setRange(PlotCsv.calculateRange(plot));
        for (int i = 0; i < plot.getCategories().size(); ++i) {
            plot.getRenderer().setSeriesStroke(i, (Stroke)new BasicStroke(3.0f));
        }
    }

    private static Range calculateRange(CategoryPlot plot) {
        double upperBound = 0.0;
        double lowerBound = 100.0;
        for (int series = 0; series < plot.getDataset().getRowCount(); ++series) {
            for (int item = 0; item < plot.getDataset().getColumnCount(); ++item) {
                Number value = plot.getDataset().getValue(series, item);
                if (value == null) continue;
                lowerBound = Math.min(lowerBound, value.doubleValue());
                upperBound = Math.max(upperBound, value.doubleValue());
            }
        }
        double margin = 0.1 * (upperBound - lowerBound);
        return new Range(Math.max(0.0, lowerBound - margin), Math.min(100.0, upperBound + margin));
    }

    private void applyTheme(JFreeChart chart) {
        StandardChartTheme theme = (StandardChartTheme)StandardChartTheme.createJFreeTheme();
        theme.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier((Paint[])this.getWheelColors(), DefaultDrawingSupplier.DEFAULT_FILL_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
        theme.setPlotBackgroundPaint((Paint)this.style.background());
        theme.setChartBackgroundPaint((Paint)this.style.background());
        theme.setLegendBackgroundPaint((Paint)this.style.background());
        theme.setTitlePaint((Paint)this.style.label());
        theme.setSubtitlePaint((Paint)this.style.axisLabel());
        theme.setLegendItemPaint((Paint)this.style.legend());
        theme.setItemLabelPaint((Paint)this.style.label());
        theme.setAxisLabelPaint((Paint)this.style.axisLabel());
        theme.setTickLabelPaint((Paint)this.style.axisLabel());
        theme.setRangeGridlinePaint((Paint)this.style.gridLine());
        theme.setDomainGridlinePaint((Paint)this.style.gridLine());
        theme.setGridBandPaint((Paint)this.style.gridBand());
        theme.setExtraLargeFont(this.style.extraLargeFont());
        theme.setRegularFont(this.style.regularFont());
        theme.setLargeFont(this.style.largeFont());
        if (Strings.isNullOrEmpty((String)this.title)) {
            theme.setAxisOffset(this.style.axisOffset());
        }
        theme.apply(chart);
    }

    private void configureGrid(CategoryPlot plot) {
        plot.setDomainGridlineStroke((Stroke)new BasicStroke());
        plot.setDomainGridlinePaint((Paint)this.style.gridLine());
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlineStroke((Stroke)new BasicStroke());
        plot.setRangeGridlinePaint((Paint)this.style.gridLine());
        plot.setRangeGridlinesVisible(true);
        plot.setOutlineVisible(false);
    }

    private void configureAxis(Axis axis) {
        axis.setAxisLineVisible(true);
        axis.setTickMarksVisible(true);
        axis.setAxisLinePaint((Paint)this.style.axisLine());
        axis.setTickMarkPaint((Paint)this.style.axisLine());
        axis.setTickLabelPaint((Paint)this.style.axisLine());
    }

    private Color[] getWheelColors() {
        int wheelStep = 3;
        int paintIndex = 0;
        Color[] colors = new Color[360];
        boolean[] wheelPaints = new boolean[colors.length];
        while (paintIndex < colors.length) {
            int step = colors.length / wheelStep;
            for (int angle = 0; angle < colors.length; angle += step) {
                if (wheelPaints[angle]) continue;
                wheelPaints[angle] = true;
                float hue = (float)angle / (float)colors.length;
                colors[paintIndex++] = this.getLineColor(hue);
            }
            wheelStep += wheelStep;
        }
        return colors;
    }

    private Color getLineColor(float hue) {
        int rgb = 0xFFFFFF & Color.HSBtoRGB(hue, this.style.saturation(), this.style.brightness());
        int a = (int)((double)this.style.alpha() * 255.0 + 0.5) << 24;
        return new Color(rgb | a, true);
    }

    public record ChartStyle(RectangleInsets axisOffset, Font extraLargeFont, Font regularFont, Font largeFont, Color background, Color axisLabel, Color axisLine, Color subtitle, float brightness, float saturation, Color legend, Color label, Color title, Color gridLine, Color gridBand, float alpha) implements Serializable
    {
        public ChartStyle {
            Objects.requireNonNull(extraLargeFont);
            Objects.requireNonNull(regularFont);
            Objects.requireNonNull(axisOffset);
            Objects.requireNonNull(background);
            Objects.requireNonNull(largeFont);
            Objects.requireNonNull(axisLabel);
            Objects.requireNonNull(axisLine);
            Objects.requireNonNull(gridLine);
            Objects.requireNonNull(gridBand);
            Objects.requireNonNull(subtitle);
            Objects.requireNonNull(legend);
            Objects.requireNonNull(label);
            Objects.requireNonNull(title);
        }

        public static ChartStyle forColors(Color background, Color content, Color grid) {
            return new ChartStyle(new RectangleInsets(20.0, 20.0, 20.0, 20.0), new Font("Helvetica", 1, 18), new Font("Helvetica", 0, 12), new Font("Helvetica", 1, 14), background, content, content, content, 0.6f, 0.7f, content, content, content, grid, grid, 0.8f);
        }

        public static ChartStyle light() {
            Color grid = new Color(15657173);
            Color content = new Color(0x585858);
            Color background = new Color(16643811);
            return ChartStyle.forColors(background, content, grid);
        }

        public static ChartStyle dark() {
            Color grid = new Color(472642);
            Color content = new Color(9675169);
            Color background = new Color(11062);
            return ChartStyle.forColors(background, content, grid);
        }
    }
}

