/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.linked;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import org.jspecify.annotations.Nullable;

@Policy.PolicySpec(name="linked.Sieve", characteristics={Policy.Characteristic.WEIGHTED})
public final class SievePolicy
implements Policy {
    final Long2ObjectMap<Node> data = new Long2ObjectOpenHashMap();
    final PolicyStats policyStats = new PolicyStats(this.name(), new Object[0]);
    final long maximumSize;
    @Nullable Node head;
    @Nullable Node tail;
    @Nullable Node hand;
    long size;

    public SievePolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.maximumSize = settings.maximumSize();
    }

    @Override
    public void record(AccessEvent event) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(event.key());
        if (node == null) {
            this.onMiss(event);
        } else {
            this.onHit(event, node);
        }
    }

    private void onHit(AccessEvent event, Node node) {
        this.policyStats.recordWeightedHit(event.weight());
        this.size += (long)(event.weight() - node.weight);
        node.weight = event.weight();
        node.visited = true;
        while (this.size > this.maximumSize) {
            this.evict();
        }
    }

    private void onMiss(AccessEvent event) {
        if ((long)event.weight() > this.maximumSize) {
            this.policyStats.recordWeightedMiss(event.weight());
            return;
        }
        while (this.size + (long)event.weight() >= this.maximumSize) {
            this.evict();
        }
        this.policyStats.recordWeightedMiss(event.weight());
        Node node = new Node(event.key(), event.weight());
        this.data.put(event.key(), (Object)node);
        this.size += (long)event.weight();
        this.addToHead(node);
    }

    private void evict() {
        Node victim;
        Node node = victim = this.hand == null ? this.tail : this.hand;
        while (victim != null && victim.visited) {
            victim.visited = false;
            victim = victim.prev == null ? this.tail : victim.prev;
            this.policyStats.recordOperation();
        }
        if (victim != null) {
            this.policyStats.recordEviction();
            this.data.remove(victim.key);
            this.size -= (long)victim.weight;
            this.hand = victim.prev;
            this.remove(victim);
        }
    }

    private void addToHead(Node node) {
        Preconditions.checkState((node.prev == null ? 1 : 0) != 0);
        Preconditions.checkState((node.next == null ? 1 : 0) != 0);
        node.next = this.head;
        if (this.head != null) {
            this.head.prev = node;
        }
        this.head = node;
        if (this.tail == null) {
            this.tail = node;
        }
    }

    private void remove(Node node) {
        if (node.prev != null) {
            node.prev.next = node.next;
        } else {
            this.head = node.next;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        } else {
            this.tail = node.prev;
        }
    }

    @Override
    public void finished() {
        Preconditions.checkState((this.size <= this.maximumSize ? 1 : 0) != 0, (String)"%s > %s", (long)this.size, (long)this.maximumSize);
        long weightedSize = this.data.values().stream().mapToLong(node -> node.weight).sum();
        Preconditions.checkState((weightedSize == this.size ? 1 : 0) != 0, (String)"%s != %s", (long)weightedSize, (long)this.size);
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static final class Node {
        final long key;
        @Nullable Node prev;
        @Nullable Node next;
        int weight;
        boolean visited;

        Node() {
            this.key = Long.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        Node(long key, int weight) {
            this.key = key;
            this.weight = weight;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("weight", this.weight).add("visited", this.visited).toString();
        }
    }
}

