/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import org.jspecify.annotations.Nullable;

public final class PolicyActor {
    private final CompletableFuture<@Nullable Void> completed;
    private final Semaphore semaphore;
    private final Policy policy;
    private final Thread parent;
    private CompletableFuture<@Nullable Void> future;

    public PolicyActor(Thread parent, Policy policy, BasicSettings settings) {
        this.semaphore = new Semaphore(settings.actor().mailboxSize());
        this.future = CompletableFuture.completedFuture(null);
        this.completed = new CompletableFuture();
        this.policy = Objects.requireNonNull(policy);
        this.parent = Objects.requireNonNull(parent);
    }

    public void send(List<AccessEvent> events) {
        this.submit(new Execute(events));
    }

    public void finish() {
        this.submit(new Finish());
    }

    public CompletableFuture<@Nullable Void> completed() {
        return this.completed;
    }

    private void submit(Command command) {
        try {
            this.semaphore.acquire();
            this.future = this.future.thenRunAsync(command);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    public PolicyStats stats() {
        return this.policy.stats();
    }

    private final class Execute
    extends Command {
        final List<AccessEvent> events;

        Execute(List<AccessEvent> events) {
            this.events = Objects.requireNonNull(events);
        }

        @Override
        public void execute() {
            PolicyActor.this.policy.stats().stopwatch().start();
            for (AccessEvent event : this.events) {
                long priorMisses = PolicyActor.this.policy.stats().missCount();
                long priorHits = PolicyActor.this.policy.stats().hitCount();
                PolicyActor.this.policy.record(event);
                if (PolicyActor.this.policy.stats().hitCount() > priorHits) {
                    PolicyActor.this.policy.stats().recordHitPenalty(event.hitPenalty());
                    continue;
                }
                if (PolicyActor.this.policy.stats().missCount() <= priorMisses) continue;
                PolicyActor.this.policy.stats().recordMissPenalty(event.missPenalty());
            }
            PolicyActor.this.policy.stats().stopwatch().stop();
        }
    }

    private abstract class Command
    implements Runnable {
        private Command() {
        }

        @Override
        public final void run() {
            String name = Thread.currentThread().getName();
            Thread.currentThread().setName(PolicyActor.this.policy.getClass().getSimpleName());
            try {
                this.execute();
            }
            catch (Throwable t) {
                PolicyActor.this.completed.completeExceptionally(t);
                PolicyActor.this.parent.interrupt();
                throw t;
            }
            finally {
                PolicyActor.this.semaphore.release();
                Thread.currentThread().setName(name);
            }
        }

        protected abstract void execute();
    }

    private final class Finish
    extends Command {
        private Finish() {
        }

        @Override
        public void execute() {
            PolicyActor.this.policy.finished();
            PolicyActor.this.completed.complete(null);
        }
    }
}

