/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report.csv;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.univocity.parsers.common.record.Record;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import picocli.CommandLine;

@CommandLine.Command(mixinStandardHelpOptions=true)
public final class CombinedCsvReport
implements Runnable {
    @CommandLine.Option(names={"--inputFiles"}, required=true, split=",", description={"The maximumSize to the csv file path"})
    private Map<Long, Path> inputFiles;
    @CommandLine.Option(names={"--metric"}, required=true, defaultValue="Hit Rate", description={"The metric to compare (use _ for spaces)"})
    private String metric;
    @CommandLine.Option(names={"--outputFile"}, required=true, description={"The combined report"})
    private Path outputFile;

    @Override
    public void run() {
        this.normalize();
        this.writeReport(this.tabulate());
        System.out.printf("Wrote combined report to %s%n", this.outputFile);
    }

    private void normalize() {
        this.metric = this.metric.replaceAll("_", " ");
        this.inputFiles = new TreeMap<Long, Path>(this.inputFiles);
    }

    private Table<String, Long, String> tabulate() {
        HashBasedTable results = HashBasedTable.create();
        this.inputFiles.forEach((arg_0, arg_1) -> this.lambda$tabulate$0((Table)results, arg_0, arg_1));
        return results;
    }

    private void writeReport(Table<String, Long, String> table) {
        List policies = this.newCsvParser().parseAllRecords(this.inputFiles.values().iterator().next().toFile()).stream().map(record -> record.getString("Policy")).collect(Collectors.toList());
        NumberFormat formatter = NumberFormat.getInstance(Locale.US);
        String[] headers = (String[])Stream.concat(Stream.of("Policy"), this.inputFiles.keySet().stream().map(formatter::format)).toArray(String[]::new);
        CsvWriter writer = this.newWriter(headers);
        for (String policy : policies) {
            writer.addValue("Policy", (Object)policy);
            for (Long size : this.inputFiles.keySet()) {
                writer.addValue(formatter.format(size), table.get((Object)policy, (Object)size));
            }
            writer.writeValuesToRow();
        }
        writer.close();
    }

    private CsvParser newCsvParser() {
        CsvParserSettings settings = new CsvParserSettings();
        settings.setHeaderExtractionEnabled(true);
        return new CsvParser(settings);
    }

    private CsvWriter newWriter(String[] headers) {
        CsvWriterSettings settings = new CsvWriterSettings();
        settings.setHeaderWritingEnabled(true);
        settings.setHeaders(headers);
        return new CsvWriter(this.outputFile.toFile(), settings);
    }

    public static void main(String[] args) {
        new CommandLine(CombinedCsvReport.class).setCommandName(CombinedCsvReport.class.getSimpleName()).setColorScheme(CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON)).setCaseInsensitiveEnumValuesAllowed(true).execute(args);
    }

    private /* synthetic */ void lambda$tabulate$0(Table results, Long maximumSize, Path path) {
        List records = this.newCsvParser().parseAllRecords(path.toFile());
        for (Record record : records) {
            results.put((Object)record.getString("Policy"), (Object)maximumSize, (Object)((String)record.getValue(this.metric, (Object)"")));
        }
    }
}

