/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing;

import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.HillClimber;
import com.google.common.base.Preconditions;

public abstract class AbstractClimber
implements HillClimber {
    private static final boolean debug = false;
    protected int sampleSize;
    protected int hitsInMain;
    protected int hitsInWindow;
    protected int hitsInSample;
    protected int missesInSample;
    protected double previousHitRate;

    @Override
    public void onMiss(long key, boolean isFull) {
        if (isFull) {
            ++this.missesInSample;
        }
    }

    @Override
    public void onHit(long key, HillClimber.QueueType queueType, boolean isFull) {
        if (isFull) {
            ++this.hitsInSample;
            if (queueType == HillClimber.QueueType.WINDOW) {
                ++this.hitsInWindow;
            } else {
                ++this.hitsInMain;
            }
        }
    }

    @Override
    public HillClimber.Adaptation adapt(double windowSize, double probationSize, double protectedSize, boolean isFull) {
        if (!isFull) {
            return HillClimber.Adaptation.hold();
        }
        Preconditions.checkState((this.sampleSize > 0 ? 1 : 0) != 0, (Object)"Sample size may not be zero");
        int sampleCount = this.hitsInSample + this.missesInSample;
        if (sampleCount < this.sampleSize) {
            return HillClimber.Adaptation.hold();
        }
        double hitRate = (double)this.hitsInSample / (double)sampleCount;
        HillClimber.Adaptation adaption = HillClimber.Adaptation.adaptBy(this.adjust(hitRate));
        this.resetSample(hitRate);
        return adaption;
    }

    protected abstract double adjust(double var1);

    protected void resetSample(double hitRate) {
        this.previousHitRate = hitRate;
        this.missesInSample = 0;
        this.hitsInSample = 0;
        this.hitsInWindow = 0;
        this.hitsInMain = 0;
    }
}

