/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.tinycache;

import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.HashedItem;

final class TinySetIndexing {
    public int chainStart;
    public int chainEnd;

    TinySetIndexing() {
    }

    public int getChainStart(HashedItem fpaux, long[] chainIndex, long[] isLastIndex) {
        int requiredChainNumber = this.rank(chainIndex[fpaux.set], fpaux.chainId);
        int currentChainNumber = this.rank(isLastIndex[fpaux.set], requiredChainNumber);
        int currentOffset = requiredChainNumber;
        long tempIsLastIndex = isLastIndex[fpaux.set] >>> requiredChainNumber;
        while (currentChainNumber < requiredChainNumber) {
            currentChainNumber += (int)tempIsLastIndex & 1;
            ++currentOffset;
            tempIsLastIndex >>>= 1;
        }
        return currentOffset;
    }

    public int rank(long index, int bitNum) {
        return Long.bitCount(index & (-1L << bitNum ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public int getChain(HashedItem fpaux, long[] chainIndex, long[] isLastIndex) {
        int requiredChainNumber = this.rank(chainIndex[fpaux.set], fpaux.chainId);
        int currentChainNumber = this.rank(isLastIndex[fpaux.set], requiredChainNumber);
        int currentOffset = requiredChainNumber;
        long tempisLastIndex = isLastIndex[fpaux.set] >>> requiredChainNumber;
        while (currentChainNumber < requiredChainNumber) {
            currentChainNumber += (int)tempisLastIndex & 1;
            ++currentOffset;
            tempisLastIndex >>>= 1;
        }
        this.chainStart = currentOffset;
        while ((tempisLastIndex & 1L) == 0L) {
            ++currentOffset;
            tempisLastIndex >>>= 1;
        }
        this.chainEnd = currentOffset;
        return currentOffset;
    }

    public int getChainAtOffset(HashedItem fpaux, long[] chainIndex, long[] isLastIndex, int offset) {
        int nonEmptyChainsToSee = this.rank(isLastIndex[fpaux.set], offset);
        int nonEmptyChainSeen = this.rank(chainIndex[fpaux.set], nonEmptyChainsToSee);
        int i = nonEmptyChainsToSee;
        while (i <= 64) {
            if (this.chainExist(chainIndex[fpaux.set], i) && nonEmptyChainSeen == nonEmptyChainsToSee) {
                return i;
            }
            nonEmptyChainSeen = this.rank(chainIndex[fpaux.set], i += Math.max(1, nonEmptyChainsToSee - nonEmptyChainSeen));
        }
        throw new RuntimeException("Cannot choose victim!");
    }

    public boolean chainExist(long chainIndex, int chainId) {
        return (chainIndex | 1L << chainId) == chainIndex;
    }

    public int addItem(HashedItem fpaux, long[] chainIndex, long[] lastIndex) {
        int offset = this.getChainStart(fpaux, chainIndex, lastIndex);
        long mask = 1L << fpaux.chainId;
        lastIndex[fpaux.set] = this.extendZero(lastIndex[fpaux.set], offset);
        if ((mask | chainIndex[fpaux.set]) != chainIndex[fpaux.set]) {
            int n = fpaux.set;
            chainIndex[n] = chainIndex[n] | mask;
            int n2 = fpaux.set;
            lastIndex[n2] = lastIndex[n2] | 1L << offset;
        }
        return offset;
    }

    private long extendZero(long isLastIndex, int offset) {
        long constantPartMask = (1L << offset) - 1L;
        return isLastIndex & constantPartMask | isLastIndex << 1 & (constantPartMask ^ 0xFFFFFFFFFFFFFFFFL) & (1L << offset ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private long shrinkOffset(long isLastIndex, int offset) {
        long conMask = (1L << offset) - 1L;
        return isLastIndex & conMask | ((conMask ^ 0xFFFFFFFFFFFFFFFFL) & isLastIndex) >>> 1;
    }

    public void removeItem(HashedItem fpaux, long[] chainIndex, long[] isLastIndex) {
        int chainStart = this.getChainStart(fpaux, chainIndex, isLastIndex);
        chainIndex[fpaux.set] = (isLastIndex[fpaux.set] & 1L << chainStart) == 0L ? chainIndex[fpaux.set] : chainIndex[fpaux.set] & (1L << fpaux.chainId ^ 0xFFFFFFFFFFFFFFFFL);
        isLastIndex[fpaux.set] = this.shrinkOffset(isLastIndex[fpaux.set], chainStart);
    }
}

