/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.admission.TinyLfu;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Policy.PolicySpec(name="sketch.WindowTinyLfu")
public final class WindowTinyLfuPolicy
implements Policy.KeyOnlyPolicy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final Admittor admittor;
    private final int maximumSize;
    private final Node headWindow;
    private final Node headProbation;
    private final Node headProtected;
    private final int maxWindow;
    private final int maxProtected;
    private int sizeWindow;
    private int sizeProtected;

    public WindowTinyLfuPolicy(double percentMain, WindowTinyLfuSettings settings) {
        this.policyStats = new PolicyStats(this.name() + " (%.0f%%)", 100.0 * (1.0 - percentMain));
        this.admittor = new TinyLfu(settings.config(), this.policyStats);
        this.maximumSize = Ints.checkedCast((long)settings.maximumSize());
        int maxMain = (int)((double)this.maximumSize * percentMain);
        this.maxProtected = (int)((double)maxMain * settings.percentMainProtected());
        this.data = new Long2ObjectOpenHashMap();
        this.maxWindow = this.maximumSize - maxMain;
        this.headProtected = new Node();
        this.headProbation = new Node();
        this.headWindow = new Node();
    }

    public static Set<Policy> policies(Config config) {
        WindowTinyLfuSettings settings = new WindowTinyLfuSettings(config);
        return settings.percentMain().stream().map(percentMain -> new WindowTinyLfuPolicy((double)percentMain, settings)).collect(Collectors.toSet());
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        if (node == null) {
            this.onMiss(key);
            this.policyStats.recordMiss();
        } else if (node.status == Status.WINDOW) {
            this.onWindowHit(node);
            this.policyStats.recordHit();
        } else if (node.status == Status.PROBATION) {
            this.onProbationHit(node);
            this.policyStats.recordHit();
        } else if (node.status == Status.PROTECTED) {
            this.onProtectedHit(node);
            this.policyStats.recordHit();
        } else {
            throw new IllegalStateException();
        }
    }

    private void onMiss(long key) {
        this.admittor.record(key);
        Node node = new Node(key, Status.WINDOW);
        node.appendToTail(this.headWindow);
        this.data.put(key, (Object)node);
        ++this.sizeWindow;
        this.evict();
    }

    private void onWindowHit(Node node) {
        this.admittor.record(node.key);
        node.moveToTail(this.headWindow);
    }

    private void onProbationHit(Node node) {
        this.admittor.record(node.key);
        node.remove();
        node.status = Status.PROTECTED;
        node.appendToTail(this.headProtected);
        ++this.sizeProtected;
        if (this.sizeProtected > this.maxProtected) {
            Node demote = this.headProtected.next;
            demote.remove();
            demote.status = Status.PROBATION;
            demote.appendToTail(this.headProbation);
            --this.sizeProtected;
        }
    }

    private void onProtectedHit(Node node) {
        this.admittor.record(node.key);
        node.moveToTail(this.headProtected);
    }

    private void evict() {
        if (this.sizeWindow <= this.maxWindow) {
            return;
        }
        Node candidate = this.headWindow.next;
        --this.sizeWindow;
        candidate.remove();
        candidate.status = Status.PROBATION;
        candidate.appendToTail(this.headProbation);
        if (this.data.size() > this.maximumSize) {
            Node victim = this.headProbation.next;
            Node evict = this.admittor.admit(candidate.key, victim.key) ? victim : candidate;
            this.data.remove(evict.key);
            evict.remove();
            this.policyStats.recordEviction();
        }
    }

    @Override
    public void finished() {
        long windowSize = this.data.values().stream().filter(n -> n.status == Status.WINDOW).count();
        long probationSize = this.data.values().stream().filter(n -> n.status == Status.PROBATION).count();
        long protectedSize = this.data.values().stream().filter(n -> n.status == Status.PROTECTED).count();
        Preconditions.checkState((windowSize == (long)this.sizeWindow ? 1 : 0) != 0);
        Preconditions.checkState((protectedSize == (long)this.sizeProtected ? 1 : 0) != 0);
        Preconditions.checkState((probationSize == (long)this.data.size() - windowSize - protectedSize ? 1 : 0) != 0);
        Preconditions.checkState((this.data.size() <= this.maximumSize ? 1 : 0) != 0);
    }

    public static final class WindowTinyLfuSettings
    extends BasicSettings {
        public WindowTinyLfuSettings(Config config) {
            super(config);
        }

        public List<Double> percentMain() {
            return this.config().getDoubleList("window-tiny-lfu.percent-main");
        }

        public double percentMainProtected() {
            return this.config().getDouble("window-tiny-lfu.percent-main-protected");
        }
    }

    static final class Node {
        final long key;
        Status status;
        Node prev;
        Node next;

        public Node() {
            this.key = Integer.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        public Node(long key, Status status) {
            this.status = status;
            this.key = key;
        }

        public void moveToTail(Node head) {
            this.remove();
            this.appendToTail(head);
        }

        public void appendToTail(Node head) {
            Node tail = head.prev;
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = null;
            this.next = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("status", (Object)this.status).toString();
        }
    }

    static enum Status {
        WINDOW,
        PROBATION,
        PROTECTED;

    }
}

