/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.irr;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;

@Policy.PolicySpec(name="irr.Lirs")
public final class LirsPolicy
implements Policy.KeyOnlyPolicy {
    final Long2ObjectMap<Node> data;
    final PolicyStats policyStats;
    final List<Object> evicted;
    final Node headNR;
    final Node headS;
    final Node headQ;
    final int maximumNonResidentSize;
    final int maximumHotSize;
    final int maximumSize;
    int sizeS;
    int sizeQ;
    int sizeNR;
    int sizeHot;
    int residentSize;
    static final boolean debug = false;

    public LirsPolicy(Config config) {
        LirsSettings settings = new LirsSettings(config);
        this.maximumSize = Ints.checkedCast((long)settings.maximumSize());
        this.maximumNonResidentSize = (int)((double)this.maximumSize * settings.nonResidentMultiplier());
        this.maximumHotSize = (int)((double)this.maximumSize * settings.percentHot());
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        this.data = new Long2ObjectOpenHashMap();
        this.evicted = new ArrayList<Object>();
        this.headNR = new Node();
        this.headS = new Node();
        this.headQ = new Node();
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        if (node == null) {
            node = new Node(key);
            this.data.put(key, (Object)node);
            this.onNonResidentHir(node);
        } else if (node.status == Status.LIR) {
            this.onLir(node);
        } else if (node.status == Status.HIR_RESIDENT) {
            this.onResidentHir(node);
        } else if (node.status == Status.HIR_NON_RESIDENT) {
            node.removeFrom(StackType.NR);
            this.onNonResidentHir(node);
        } else {
            throw new IllegalStateException();
        }
    }

    private void onLir(Node node) {
        this.policyStats.recordHit();
        boolean wasBottom = this.headS.prevS == node;
        node.moveToTop(StackType.S);
        if (wasBottom) {
            this.pruneStack();
        }
    }

    private void onResidentHir(Node node) {
        this.policyStats.recordHit();
        boolean isInStack = node.isInStack(StackType.S);
        boolean isTop = node.isStackTop(StackType.S);
        node.moveToTop(StackType.S);
        if (isInStack && !isTop) {
            ++this.sizeHot;
            node.status = Status.LIR;
            node.removeFrom(StackType.Q);
            Node bottom = this.headS.prevS;
            --this.sizeHot;
            bottom.status = Status.HIR_RESIDENT;
            bottom.removeFrom(StackType.S);
            bottom.moveToTop(StackType.Q);
            this.pruneStack();
        } else {
            node.moveToTop(StackType.Q);
        }
    }

    private void onNonResidentHir(Node node) {
        this.policyStats.recordMiss();
        if (this.sizeHot < this.maximumHotSize) {
            this.onLirWarmupMiss(node);
        } else if (this.residentSize < this.maximumSize) {
            this.onHirWarmupMiss(node);
        } else {
            this.onFullMiss(node);
        }
        ++this.residentSize;
    }

    private void onLirWarmupMiss(Node node) {
        node.moveToTop(StackType.S);
        node.status = Status.LIR;
        ++this.sizeHot;
    }

    private void onHirWarmupMiss(Node node) {
        node.status = Status.HIR_RESIDENT;
        node.moveToTop(StackType.Q);
    }

    private void onFullMiss(Node node) {
        node.status = Status.HIR_RESIDENT;
        if (this.residentSize >= this.maximumSize) {
            this.evict();
        }
        boolean isInStack = node.isInStack(StackType.S);
        node.moveToTop(StackType.S);
        if (isInStack) {
            node.status = Status.LIR;
            ++this.sizeHot;
            Node bottom = this.headS.prevS;
            Preconditions.checkState((bottom.status == Status.LIR ? 1 : 0) != 0);
            bottom.status = Status.HIR_RESIDENT;
            bottom.removeFrom(StackType.S);
            bottom.moveToTop(StackType.Q);
            --this.sizeHot;
            this.pruneStack();
        } else {
            node.moveToTop(StackType.Q);
        }
    }

    private void pruneStack() {
        Node bottom;
        while ((bottom = this.headS.prevS) != this.headS && bottom.status != Status.LIR) {
            if (bottom.status == Status.HIR_NON_RESIDENT) {
                bottom.removeFrom(StackType.NR);
                this.data.remove(bottom.key);
            }
            bottom.removeFrom(StackType.S);
            this.policyStats.recordOperation();
        }
        Node node = this.headNR.prevNR;
        while (this.sizeNR > this.maximumNonResidentSize) {
            this.policyStats.recordOperation();
            Node removed = node;
            node = node.prevNR;
            removed.removeFrom(StackType.NR);
            removed.removeFrom(StackType.S);
            this.data.remove(removed.key);
        }
    }

    private void evict() {
        this.policyStats.recordEviction();
        --this.residentSize;
        Node bottom = this.headQ.prevQ;
        bottom.removeFrom(StackType.Q);
        bottom.status = Status.HIR_NON_RESIDENT;
        if (bottom.isInStack(StackType.S)) {
            bottom.moveToTop(StackType.NR);
        } else {
            this.data.remove(bottom.key);
        }
        this.pruneStack();
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        long resident = this.data.values().stream().filter(node -> node.status != Status.HIR_NON_RESIDENT).count();
        Preconditions.checkState((resident == (long)this.residentSize ? 1 : 0) != 0);
        Preconditions.checkState((this.sizeHot <= this.maximumHotSize ? 1 : 0) != 0);
        Preconditions.checkState((this.residentSize <= this.maximumSize ? 1 : 0) != 0);
        Preconditions.checkState((this.sizeNR <= this.maximumNonResidentSize ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.data.size() <= (long)this.maximumSize + (long)this.maximumNonResidentSize ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.sizeS == this.data.values().stream().filter(node -> node.isInS).count() ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.sizeQ == this.data.values().stream().filter(node -> node.isInQ).count() ? 1 : 0) != 0);
    }

    private void printLirs() {
        System.out.println("** LIRS stack TOP **");
        Node n = this.headS.nextS;
        while (n != this.headS) {
            Preconditions.checkState((boolean)n.isInS);
            if (n.status == Status.HIR_NON_RESIDENT) {
                System.out.println("<NR> " + n.key);
            } else if (n.status == Status.HIR_RESIDENT) {
                System.out.println("<RH> " + n.key);
            } else {
                System.out.println("<RL> " + n.key);
            }
            n = n.nextS;
        }
        System.out.println("** LIRS stack BOTTOM **");
        System.out.println("\n** LIRS queue END **");
        n = this.headQ.nextQ;
        while (n != this.headQ) {
            Preconditions.checkState((boolean)n.isInQ);
            System.out.println(n.key);
            n = n.nextQ;
        }
        System.out.println("** LIRS queue front **");
        System.out.println("\nLIRS EVICTED PAGE sequence:");
        for (int i = 0; i < this.evicted.size(); ++i) {
            System.out.println("<" + i + "> " + this.evicted.get(i));
        }
    }

    static final class LirsSettings
    extends BasicSettings {
        public LirsSettings(Config config) {
            super(config);
        }

        public double percentHot() {
            return this.config().getDouble("lirs.percent-hot");
        }

        public double nonResidentMultiplier() {
            return this.config().getDouble("lirs.non-resident-multiplier");
        }
    }

    final class Node {
        final long key;
        Status status;
        Node prevS;
        Node nextS;
        Node prevQ;
        Node nextQ;
        Node prevNR;
        Node nextNR;
        boolean isInS;
        boolean isInQ;
        boolean isInNR;

        Node() {
            this.key = Long.MIN_VALUE;
            this.prevS = this.nextS = this;
            this.prevQ = this.nextQ = this;
            this.prevNR = this.nextNR = this;
        }

        Node(long key) {
            this.key = key;
        }

        public boolean isInStack(StackType stackType) {
            Preconditions.checkState((this.key != Long.MIN_VALUE ? 1 : 0) != 0);
            if (stackType == StackType.S) {
                return this.isInS;
            }
            if (stackType == StackType.Q) {
                return this.isInQ;
            }
            if (stackType == StackType.NR) {
                return this.isInNR;
            }
            throw new IllegalArgumentException();
        }

        public boolean isStackTop(StackType stackType) {
            if (stackType == StackType.S) {
                return LirsPolicy.this.headS.nextS == this;
            }
            if (stackType == StackType.Q) {
                return LirsPolicy.this.headQ.nextQ == this;
            }
            if (stackType == StackType.NR) {
                return LirsPolicy.this.headNR.nextNR == this;
            }
            throw new IllegalArgumentException();
        }

        public void moveToTop(StackType stackType) {
            if (this.isInStack(stackType)) {
                this.removeFrom(stackType);
            }
            if (stackType == StackType.S) {
                Node next = LirsPolicy.this.headS.nextS;
                LirsPolicy.this.headS.nextS = this;
                next.prevS = this;
                this.nextS = next;
                this.prevS = LirsPolicy.this.headS;
                this.isInS = true;
                ++LirsPolicy.this.sizeS;
            } else if (stackType == StackType.Q) {
                Node next = LirsPolicy.this.headQ.nextQ;
                LirsPolicy.this.headQ.nextQ = this;
                next.prevQ = this;
                this.nextQ = next;
                this.prevQ = LirsPolicy.this.headQ;
                this.isInQ = true;
                ++LirsPolicy.this.sizeQ;
            } else if (stackType == StackType.NR) {
                Node next = LirsPolicy.this.headNR.nextNR;
                LirsPolicy.this.headNR.nextNR = this;
                next.prevNR = this;
                this.nextNR = next;
                this.prevNR = LirsPolicy.this.headNR;
                this.isInNR = true;
                ++LirsPolicy.this.sizeNR;
            } else {
                throw new IllegalArgumentException();
            }
        }

        public void removeFrom(StackType stackType) {
            Preconditions.checkState((boolean)this.isInStack(stackType));
            if (stackType == StackType.S) {
                this.prevS.nextS = this.nextS;
                this.nextS.prevS = this.prevS;
                this.nextS = null;
                this.prevS = null;
                this.isInS = false;
                --LirsPolicy.this.sizeS;
            } else if (stackType == StackType.Q) {
                this.prevQ.nextQ = this.nextQ;
                this.nextQ.prevQ = this.prevQ;
                this.nextQ = null;
                this.prevQ = null;
                this.isInQ = false;
                --LirsPolicy.this.sizeQ;
            } else if (stackType == StackType.NR) {
                this.prevNR.nextNR = this.nextNR;
                this.nextNR.prevNR = this.prevNR;
                this.nextNR = null;
                this.prevNR = null;
                this.isInNR = false;
                --LirsPolicy.this.sizeNR;
            } else {
                throw new IllegalArgumentException();
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("type", (Object)this.status).toString();
        }
    }

    static enum StackType {
        S,
        Q,
        NR;

    }

    static enum Status {
        LIR,
        HIR_RESIDENT,
        HIR_NON_RESIDENT;

    }
}

