/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.tinycache;

import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.HashFunctionParser;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.HashedItem;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.TinyCacheSketch;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.TinySetIndexing;
import java.util.Random;

public final class TinyCacheWithGhostCache {
    private static final int sampleSize = 10;
    public final long[] chainIndex;
    public final long[] lastIndex;
    private final HashFunctionParser hashFunc;
    private final TinyCacheSketch ghostCache;
    private final int itemsPerSet;
    private final long[] cache;
    private final Random rnd;

    public TinyCacheWithGhostCache(int nrSets, int itemsPerSet, int randomSeed) {
        this.chainIndex = new long[nrSets];
        this.lastIndex = new long[nrSets];
        this.itemsPerSet = itemsPerSet;
        this.cache = new long[nrSets * itemsPerSet];
        this.hashFunc = new HashFunctionParser(nrSets);
        this.ghostCache = new TinyCacheSketch(nrSets * 10, itemsPerSet, randomSeed + 1);
        this.rnd = new Random(randomSeed);
    }

    public boolean contains(long item) {
        this.hashFunc.createHash(item);
        if (!TinySetIndexing.chainExist(this.chainIndex[this.hashFunc.fpaux.set], this.hashFunc.fpaux.chainId)) {
            return false;
        }
        TinySetIndexing.getChain(this.hashFunc.fpaux, this.chainIndex, this.lastIndex);
        int offset = this.itemsPerSet * this.hashFunc.fpaux.set;
        TinySetIndexing.chainStart += offset;
        TinySetIndexing.chainEnd += offset;
        while (TinySetIndexing.chainStart <= TinySetIndexing.chainEnd) {
            try {
                if (this.cache[TinySetIndexing.chainStart % this.cache.length] == this.hashFunc.fpaux.value) {
                    return true;
                }
                ++TinySetIndexing.chainStart;
            }
            catch (Exception e) {
                System.out.println(" length: " + this.cache.length + " Access: " + TinySetIndexing.chainStart);
            }
        }
        return false;
    }

    private int replace(HashedItem fpaux, byte victim, int bucketStart, int removedOffset) {
        byte chainId = fpaux.chainId;
        fpaux.chainId = victim;
        this.cache[bucketStart + removedOffset] = 0L;
        TinySetIndexing.removeItem(fpaux, this.chainIndex, this.lastIndex);
        fpaux.chainId = chainId;
        int idxToAdd = TinySetIndexing.addItem(fpaux, this.chainIndex, this.lastIndex);
        int delta = removedOffset < idxToAdd ? -1 : 1;
        this.replaceItems(idxToAdd, fpaux.value, bucketStart, delta);
        return removedOffset;
    }

    public void recordItem(long item) {
        if (this.ghostCache.countItem(this.hashFunc.fpaux.value) < 10) {
            this.ghostCache.addItem(this.hashFunc.fpaux.value);
        }
    }

    public boolean addItem(long item) {
        this.hashFunc.createHash(item);
        int bucketStart = this.itemsPerSet * this.hashFunc.fpaux.set;
        if (this.cache[bucketStart + this.itemsPerSet - 1] != 0L) {
            return this.selectVictim(bucketStart);
        }
        int idxToAdd = TinySetIndexing.addItem(this.hashFunc.fpaux, this.chainIndex, this.lastIndex);
        this.replaceItems(idxToAdd, this.hashFunc.fpaux.value, bucketStart, 1);
        return false;
    }

    private boolean selectVictim(int bucketStart) {
        byte victimOffset = (byte)this.rnd.nextInt(this.itemsPerSet);
        int victimChain = TinySetIndexing.getChainAtOffset(this.hashFunc.fpaux, this.chainIndex, this.lastIndex, victimOffset);
        long victim = this.cache[bucketStart + victimOffset];
        if (TinySetIndexing.chainExist(this.chainIndex[this.hashFunc.fpaux.set], victimChain)) {
            int victimScore = this.ghostCache.countItem(victim);
            int currItemScore = this.ghostCache.countItem(this.hashFunc.fpaux.value);
            if (currItemScore > victimScore) {
                this.replace(this.hashFunc.fpaux, (byte)victimChain, bucketStart, victimOffset);
                return true;
            }
            return false;
        }
        throw new RuntimeException("Failed to replace");
    }

    private void replaceItems(int idx, long value, int start, int delta) {
        start += idx;
        do {
            long $ = this.cache[start];
            this.cache[start] = value;
            value = $;
            start += delta;
        } while (value != 0L);
    }
}

