/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.hill;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.AbstractClimber;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;

public final class SimpleClimber
extends AbstractClimber {
    private final double restartThreshold;
    private final double initialStepSize;
    private final double sampleDecayRate;
    private final int initialSampleSize;
    private final double stepDecayRate;
    private final double tolerance;
    private boolean increaseWindow;
    private double stepSize;

    public SimpleClimber(Config config) {
        SimpleClimberSettings settings = new SimpleClimberSettings(config);
        int maximumSize = Ints.checkedCast((long)settings.maximumSize());
        this.initialSampleSize = (int)(settings.percentSample() * (double)maximumSize);
        this.initialStepSize = settings.percentPivot() * (double)maximumSize;
        this.restartThreshold = settings.restartThreshold();
        this.sampleDecayRate = settings.sampleDecayRate();
        this.stepDecayRate = settings.stepDecayRate();
        this.tolerance = 100.0 * settings.tolerance();
        this.sampleSize = this.initialSampleSize;
        this.stepSize = this.initialStepSize;
    }

    @Override
    protected double adjust(double hitRate) {
        if (hitRate < this.previousHitRate + this.tolerance) {
            boolean bl = this.increaseWindow = !this.increaseWindow;
        }
        if (Math.abs(hitRate - this.previousHitRate) >= this.restartThreshold) {
            this.sampleSize = this.initialSampleSize;
            this.stepSize = this.initialStepSize;
        }
        return this.increaseWindow ? this.stepSize : -this.stepSize;
    }

    @Override
    protected void resetSample(double hitRate) {
        super.resetSample(hitRate);
        this.stepSize *= this.stepDecayRate;
        this.sampleSize = (int)((double)this.sampleSize * this.sampleDecayRate);
        if (this.stepSize <= 0.01 || this.sampleSize <= 1) {
            this.sampleSize = Integer.MAX_VALUE;
        }
    }

    static final class SimpleClimberSettings
    extends BasicSettings {
        static final String BASE_PATH = "hill-climber-window-tiny-lfu.simple.";

        public SimpleClimberSettings(Config config) {
            super(config);
        }

        public double percentPivot() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simple.percent-pivot");
        }

        public double percentSample() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simple.percent-sample");
        }

        public double tolerance() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simple.tolerance");
        }

        public double stepDecayRate() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simple.step-decay-rate");
        }

        public double sampleDecayRate() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simple.sample-decay-rate");
        }

        public double restartThreshold() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.simple.restart-threshold");
        }
    }
}

