/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import systems.comodal.collision.cache.CollisionBuilder;
import systems.comodal.collision.cache.CollisionCache;

public final class CollisionPolicy
implements Policy.KeyOnlyPolicy {
    private final CollisionCache<Object, Object> cache;
    private final PolicyStats policyStats;
    private final int maximumSize;
    private int trackedSize;

    public CollisionPolicy(CollisionSettings settings, Density density) {
        this.policyStats = new PolicyStats("product.Collision (%s)", StringUtils.capitalize((String)density.name().toLowerCase(Locale.US)));
        this.maximumSize = Ints.checkedCast((long)settings.maximumSize());
        CollisionBuilder builder = CollisionCache.withCapacity((int)this.maximumSize).setInitCount(settings.initCount()).setBucketSize(settings.bucketSize()).setStrictCapacity(settings.strictCapacity());
        if (density == Density.SPARSE) {
            this.cache = builder.buildSparse(settings.sparseFactor());
        } else if (density == Density.PACKED) {
            this.cache = builder.buildPacked();
        } else {
            throw new IllegalArgumentException();
        }
    }

    public static Set<Policy> policies(Config config) {
        CollisionSettings settings = new CollisionSettings(config);
        return settings.density().map(density -> new CollisionPolicy(settings, (Density)((Object)density))).collect(Collectors.toSet());
    }

    @Override
    public void record(long key) {
        Object value = this.cache.getIfPresent((Object)key);
        if (value == null) {
            if (this.trackedSize == this.maximumSize) {
                this.policyStats.recordEviction();
                --this.trackedSize;
            }
            this.cache.putIfAbsent((Object)key, (Object)key);
            this.policyStats.recordMiss();
            ++this.trackedSize;
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static final class CollisionSettings
    extends BasicSettings {
        public CollisionSettings(Config config) {
            super(config);
        }

        public int initCount() {
            return this.config().getInt("collision.init-count");
        }

        public int bucketSize() {
            return this.config().getInt("collision.bucket-size");
        }

        public double sparseFactor() {
            return this.config().getDouble("collision.sparse-factor");
        }

        public boolean strictCapacity() {
            return this.config().getBoolean("collision.strict-capacity");
        }

        public Stream<Density> density() {
            return this.config().getStringList("collision.density").stream().map(density -> Density.valueOf(density.toUpperCase(Locale.US)));
        }
    }

    static enum Density {
        SPARSE,
        PACKED;

    }
}

