/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.tinycache;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.TinyCache;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.TinyCacheWithGhostCache;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.util.Set;

public final class WindowTinyCachePolicy
implements Policy.KeyOnlyPolicy {
    private final TinyCache window;
    private final PolicyStats policyStats;
    private final TinyCacheWithGhostCache tinyCache;

    public WindowTinyCachePolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.policyStats = new PolicyStats("sketch.WindowTinyCache");
        int maxSize = settings.maximumSize();
        if (maxSize <= 64) {
            this.window = null;
        } else {
            maxSize -= 64;
            this.window = new TinyCache(1, 64, 0);
        }
        this.tinyCache = new TinyCacheWithGhostCache((int)Math.ceil((double)maxSize / 64.0), 64, settings.randomSeed());
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new WindowTinyCachePolicy(config));
    }

    @Override
    public void record(long key) {
        if (this.tinyCache.contains(key) || this.window != null && this.window.contains(key)) {
            this.tinyCache.recordItem(key);
            this.policyStats.recordHit();
        } else {
            boolean evicted = this.tinyCache.addItem(key);
            if (!evicted && this.window != null) {
                evicted = this.window.addItem(key);
            }
            this.tinyCache.recordItem(key);
            this.policyStats.recordMiss();
            if (evicted) {
                this.policyStats.recordEviction();
            }
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }
}

