/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import java.util.Set;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;

public final class ElasticSearchPolicy
implements Policy {
    private final Cache<Long, AccessEvent> cache;
    private final PolicyStats policyStats = new PolicyStats("product.ElasticSearch");

    public ElasticSearchPolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.cache = CacheBuilder.builder().removalListener(notification -> this.policyStats.recordEviction()).setMaximumWeight((long)settings.maximumSize()).weigher((key, value) -> value.weight()).build();
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new ElasticSearchPolicy(config));
    }

    @Override
    public Set<Policy.Characteristic> characteristics() {
        return Sets.immutableEnumSet((Enum)Policy.Characteristic.WEIGHTED, (Enum[])new Policy.Characteristic[0]);
    }

    @Override
    public void record(AccessEvent event) {
        Object value = this.cache.get((Object)event.key());
        if (value == null) {
            this.cache.put((Object)event.key(), (Object)event);
            this.policyStats.recordWeightedMiss(event.weight());
        } else {
            this.policyStats.recordWeightedHit(event.weight());
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        Cache.CacheStats stats = this.cache.stats();
        Preconditions.checkState((this.policyStats.hitCount() == stats.getHits() ? 1 : 0) != 0);
        Preconditions.checkState((this.policyStats.missCount() == stats.getMisses() ? 1 : 0) != 0);
        Preconditions.checkState((this.policyStats.evictionCount() == stats.getEvictions() ? 1 : 0) != 0);
    }
}

