/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.camelab;

import com.github.benmanes.caffeine.cache.simulator.parser.TextTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import java.io.IOException;
import java.util.stream.LongStream;

public final class CamelabTraceReader
extends TextTraceReader
implements TraceReader.KeyOnlyTraceReader {
    static final int BLOCK_SIZE = 512;

    public CamelabTraceReader(String filePath) {
        super(filePath);
    }

    @Override
    public LongStream keys() throws IOException {
        return this.lines().flatMapToLong(line -> {
            String[] array = line.split(" ", 5);
            char readWrite = Character.toLowerCase(array[1].charAt(0));
            if (readWrite == 'w') {
                return LongStream.empty();
            }
            long startAddress = Long.parseLong(array[2]);
            int requestSize = Integer.parseInt(array[3]);
            long[] blocks = new long[requestSize];
            for (int i = 0; i < requestSize; ++i) {
                blocks[i] = startAddress + (long)(i * 512);
            }
            return LongStream.of(blocks);
        });
    }
}

