/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class AccessEvent {
    private final Long key;

    private AccessEvent(long key) {
        this.key = key;
    }

    public Long key() {
        return this.key;
    }

    public int weight() {
        return 1;
    }

    public double hitPenalty() {
        return 0.0;
    }

    public double missPenalty() {
        return 0.0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessEvent)) {
            return false;
        }
        AccessEvent event = (AccessEvent)o;
        return Objects.equals(this.key(), event.key()) && Objects.equals(this.weight(), event.weight()) && Objects.equals(this.hitPenalty(), event.hitPenalty()) && Objects.equals(this.missPenalty(), event.missPenalty());
    }

    public int hashCode() {
        return Objects.hash(this.key(), this.weight(), this.missPenalty(), this.hitPenalty());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key()).add("weight", this.weight()).add("hit penalty", this.hitPenalty()).add("miss penalty", this.missPenalty()).toString();
    }

    public static AccessEvent forKey(long key) {
        return new AccessEvent(key);
    }

    public static AccessEvent forKeyAndWeight(long key, int weight) {
        return new WeightedAccessEvent(key, weight);
    }

    public static AccessEvent forKeyAndPenalties(long key, double hitPenalty, double missPenalty) {
        return new PenaltiesAccessEvent(key, hitPenalty, missPenalty);
    }

    private static long cantorHashCode(long key, int weight) {
        return (key + (long)weight) * (key + (long)weight + 1L) / 2L + (long)weight;
    }

    private static final class PenaltiesAccessEvent
    extends AccessEvent {
        private final double missPenalty;
        private final double hitPenalty;

        PenaltiesAccessEvent(long key, double hitPenalty, double missPenalty) {
            super(key);
            this.hitPenalty = hitPenalty;
            this.missPenalty = missPenalty;
            Preconditions.checkArgument((hitPenalty >= 0.0 ? 1 : 0) != 0);
            Preconditions.checkArgument((missPenalty >= hitPenalty ? 1 : 0) != 0);
        }

        @Override
        public double missPenalty() {
            return this.missPenalty;
        }

        @Override
        public double hitPenalty() {
            return this.hitPenalty;
        }
    }

    private static final class WeightedAccessEvent
    extends AccessEvent {
        private final int weight;

        WeightedAccessEvent(long key, int weight) {
            super(AccessEvent.cantorHashCode(key, weight));
            this.weight = weight;
            Preconditions.checkArgument((weight >= 0 ? 1 : 0) != 0);
        }

        @Override
        public int weight() {
            return this.weight;
        }
    }
}

