/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.countmin4;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Frequency;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;

public abstract class CountMin4
implements Frequency {
    static final long[] SEED = new long[]{-4348849565147123417L, -5435081209227447693L, -7286425919675154353L, -3750763034362895579L};
    static final long RESET_MASK = 0x7777777777777777L;
    protected final boolean conservative;
    protected int tableMask;
    protected long[] table;
    protected int step = 1;

    protected CountMin4(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.conservative = settings.tinyLfu().conservative();
        double countersMultiplier = settings.tinyLfu().countMin4().countersMultiplier();
        long counters = (long)(countersMultiplier * (double)settings.maximumSize());
        this.ensureCapacity(counters);
    }

    protected void ensureCapacity(long maximumSize) {
        Preconditions.checkArgument((maximumSize >= 0L ? 1 : 0) != 0);
        int maximum = (int)Math.min(maximumSize, 0x3FFFFFFFL);
        if (this.table != null && this.table.length >= maximum) {
            return;
        }
        this.table = new long[maximum == 0 ? 1 : CountMin4.ceilingNextPowerOfTwo(maximum)];
        this.tableMask = Math.max(0, this.table.length - 1);
    }

    @Override
    public int frequency(long e) {
        int hash = this.spread(Long.hashCode(e));
        int start = (hash & 3) << 2;
        int frequency = Integer.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            int index = this.indexOf(hash, i);
            int count = (int)(this.table[index] >>> (start + i << 2) & 0xFL);
            frequency = Math.min(frequency, count);
        }
        return frequency;
    }

    @Override
    public void increment(long e) {
        if (this.conservative) {
            this.conservativeIncrement(e);
        } else {
            this.regularIncrement(e);
        }
    }

    void regularIncrement(long e) {
        int hash = this.spread(Long.hashCode(e));
        int start = (hash & 3) << 2;
        int index0 = this.indexOf(hash, 0);
        int index1 = this.indexOf(hash, 1);
        int index2 = this.indexOf(hash, 2);
        int index3 = this.indexOf(hash, 3);
        boolean added = this.incrementAt(index0, start, this.step);
        added |= this.incrementAt(index1, start + 1, this.step);
        added |= this.incrementAt(index2, start + 2, this.step);
        this.tryReset(added |= this.incrementAt(index3, start + 3, this.step));
    }

    void conservativeIncrement(long e) {
        int i;
        int hash = this.spread(Long.hashCode(e));
        int start = (hash & 3) << 2;
        int[] index = new int[4];
        int[] count = new int[4];
        int min = Integer.MAX_VALUE;
        for (i = 0; i < 4; ++i) {
            index[i] = this.indexOf(hash, i);
            count[i] = (int)(this.table[index[i]] >>> (start + i << 2) & 0xFL);
            min = Math.min(min, count[i]);
        }
        if (min == 15) {
            this.tryReset(false);
            return;
        }
        for (i = 0; i < 4; ++i) {
            if (count[i] != min) continue;
            this.incrementAt(index[i], start + i, this.step);
        }
        this.tryReset(true);
    }

    protected void tryReset(boolean added) {
    }

    boolean incrementAt(int i, int j, long step) {
        int offset = j << 2;
        long mask = 15L << offset;
        if ((this.table[i] & mask) != mask) {
            long current = (this.table[i] & mask) >>> offset;
            long update = Math.min(current + step, 15L);
            this.table[i] = this.table[i] & (mask ^ 0xFFFFFFFFFFFFFFFFL) | update << offset;
            return true;
        }
        return false;
    }

    int indexOf(int item, int i) {
        long hash = ((long)item + SEED[i]) * SEED[i];
        hash += hash >>> 32;
        return (int)hash & this.tableMask;
    }

    int spread(int x) {
        x = (x >>> 16 ^ x) * 73244475;
        x = (x >>> 16 ^ x) * 73244475;
        return x >>> 16 ^ x;
    }

    static int ceilingNextPowerOfTwo(int x) {
        return 1 << -Integer.numberOfLeadingZeros(x - 1);
    }
}

