/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report;

import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.report.TextReporter;
import com.typesafe.config.Config;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class CsvReporter
extends TextReporter {
    public CsvReporter(Config config) {
        super(config);
    }

    @Override
    protected String assemble(List<PolicyStats> results) {
        StringWriter output = new StringWriter();
        CsvWriter writer = new CsvWriter((Writer)output, new CsvWriterSettings());
        writer.writeHeaders(this.headers());
        for (PolicyStats policyStats : results) {
            Object[] data = new Object[]{policyStats.name(), String.format("%.2f", 100.0 * policyStats.hitRate()), policyStats.hitCount(), policyStats.missCount(), policyStats.requestCount(), policyStats.evictionCount(), String.format("%.2f", 100.0 * policyStats.admissionRate()), policyStats.operationCount() == 0L ? null : Long.valueOf(policyStats.operationCount()), policyStats.stopwatch().elapsed(TimeUnit.MILLISECONDS)};
            writer.writeRow(data);
        }
        writer.close();
        return output.toString();
    }
}

