/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.util.Set;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;

public final class ElasticSearchPolicy
implements Policy {
    private final Cache<Object, Object> cache;
    private final PolicyStats policyStats = new PolicyStats("product.ElasticSearch");
    private final int maximumSize;

    public ElasticSearchPolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.maximumSize = settings.maximumSize();
        this.cache = CacheBuilder.builder().setMaximumWeight((long)this.maximumSize).build();
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new ElasticSearchPolicy(config));
    }

    @Override
    public void record(long key) {
        Object value = this.cache.get((Object)key);
        if (value == null) {
            if (this.cache.count() == this.maximumSize) {
                this.policyStats.recordEviction();
            }
            this.cache.put((Object)key, (Object)key);
            this.policyStats.recordMiss();
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        Cache.CacheStats stats = this.cache.stats();
        Preconditions.checkState((this.policyStats.hitCount() == stats.getHits() ? 1 : 0) != 0);
        Preconditions.checkState((this.policyStats.missCount() == stats.getMisses() ? 1 : 0) != 0);
        Preconditions.checkState((this.policyStats.evictionCount() == stats.getEvictions() ? 1 : 0) != 0);
    }
}

