/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;

public final class Ehcache2Policy
implements Policy {
    private static final CacheManager cacheManager = new CacheManager();
    private final PolicyStats policyStats;
    private final int maximumSize;
    private final Ehcache cache;

    public Ehcache2Policy(Config config) {
        Ehcache2Settings settings = new Ehcache2Settings(config);
        this.maximumSize = settings.maximumSize();
        this.policyStats = new PolicyStats("product.Ehcache2");
        CacheConfiguration configuration = new CacheConfiguration("ehcache2", this.maximumSize);
        configuration.setMemoryStoreEvictionPolicyFromObject(settings.policy());
        this.cache = new Cache(configuration);
        cacheManager.addCache(this.cache);
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new Ehcache2Policy(config));
    }

    @Override
    public void record(long key) {
        Element value = this.cache.get((Serializable)Long.valueOf(key));
        if (value == null) {
            this.policyStats.recordMiss();
            if (this.cache.getSize() == this.maximumSize) {
                this.policyStats.recordEviction();
            }
            this.cache.put(new Element((Serializable)Long.valueOf(key), (Serializable)Long.valueOf(key)));
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static final class Ehcache2Settings
    extends BasicSettings {
        public Ehcache2Settings(Config config) {
            super(config);
        }

        public MemoryStoreEvictionPolicy policy() {
            return MemoryStoreEvictionPolicy.fromString((String)this.config().getString("ehcache2.policy"));
        }
    }
}

