/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.util.Set;

public final class CaffeinePolicy
implements Policy {
    private final Cache<Object, Object> cache;
    private final PolicyStats policyStats = new PolicyStats("product.Caffeine");
    private final int maximumSize;

    public CaffeinePolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.maximumSize = settings.maximumSize();
        this.cache = Caffeine.newBuilder().initialCapacity(this.maximumSize).maximumSize((long)this.maximumSize).executor(Runnable::run).build();
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new CaffeinePolicy(config));
    }

    @Override
    public void record(long key) {
        Object value = this.cache.getIfPresent((Object)key);
        if (value == null) {
            if (this.cache.estimatedSize() == (long)this.maximumSize) {
                this.policyStats.recordEviction();
            }
            this.cache.put((Object)key, (Object)key);
            this.policyStats.recordMiss();
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }
}

