/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.membership.bloom;

import com.github.benmanes.caffeine.cache.simulator.membership.Membership;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;

public final class GuavaBloomFilter
implements Membership {
    private final long expectedInsertions;
    private final double fpp;
    private BloomFilter<Long> bloomFilter;

    public GuavaBloomFilter(long expectedInsertions, double fpp) {
        this.expectedInsertions = expectedInsertions;
        this.fpp = fpp;
        this.bloomFilter = this.makeBloomFilter();
    }

    @Override
    public boolean mightContain(long e) {
        return this.bloomFilter.mightContain((Object)e);
    }

    @Override
    public void clear() {
        this.bloomFilter = this.makeBloomFilter();
    }

    @Override
    public boolean put(long e) {
        return this.bloomFilter.put((Object)e);
    }

    private BloomFilter<Long> makeBloomFilter() {
        return BloomFilter.create((Funnel)Funnels.longFunnel(), (long)this.expectedInsertions, (double)this.fpp);
    }
}

