/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.event;

import com.github.benmanes.caffeine.cache.CacheWriter;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.jcache.Expirable;
import com.github.benmanes.caffeine.jcache.event.EventDispatcher;
import com.github.benmanes.caffeine.jcache.management.JCacheStatisticsMXBean;
import java.util.Objects;
import javax.cache.Cache;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JCacheEvictionListener<K, V>
implements CacheWriter<K, Expirable<V>> {
    private final JCacheStatisticsMXBean statistics;
    private final EventDispatcher<K, V> dispatcher;
    private Cache<K, V> cache;

    public JCacheEvictionListener(EventDispatcher<K, V> dispatcher, JCacheStatisticsMXBean statistics) {
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.statistics = Objects.requireNonNull(statistics);
    }

    public void setCache(Cache<K, V> cache) {
        this.cache = Objects.requireNonNull(cache);
    }

    public void write(K key, Expirable<V> value) {
    }

    public void delete(K key, @Nullable Expirable<V> expirable, RemovalCause cause) {
        if (cause.wasEvicted() && expirable != null) {
            V value = expirable.get();
            if (cause == RemovalCause.EXPIRED) {
                this.dispatcher.publishExpiredQuietly(this.cache, key, value);
            } else {
                this.dispatcher.publishRemovedQuietly(this.cache, key, value);
            }
            this.statistics.recordEvictions(1L);
        }
    }
}

