/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.spi;

import com.github.benmanes.caffeine.jcache.CacheManagerImpl;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.annotation.concurrent.GuardedBy;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;

public final class CaffeineCachingProvider
implements CachingProvider {
    @GuardedBy(value="itself")
    private final Map<ClassLoader, Map<URI, CacheManager>> cacheManagers = new WeakHashMap<ClassLoader, Map<URI, CacheManager>>(1);

    public ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    public URI getDefaultURI() {
        return URI.create(this.getClass().getName());
    }

    public Properties getDefaultProperties() {
        return new Properties();
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader());
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, this.getDefaultProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        URI managerURI = this.getManagerUri(uri);
        ClassLoader managerClassLoader = this.getManagerClassLoader(classLoader);
        Map<ClassLoader, Map<URI, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            Map cacheManagersByURI = this.cacheManagers.computeIfAbsent(managerClassLoader, any -> new HashMap());
            return cacheManagersByURI.computeIfAbsent(managerURI, any -> {
                Properties managerProperties = properties == null ? this.getDefaultProperties() : properties;
                return new CacheManagerImpl(this, managerURI, managerClassLoader, managerProperties);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<ClassLoader, Map<URI, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            for (ClassLoader classLoader : new ArrayList<ClassLoader>(this.cacheManagers.keySet())) {
                this.close(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ClassLoader classLoader) {
        Map<ClassLoader, Map<URI, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ClassLoader managerClassLoader = this.getManagerClassLoader(classLoader);
            Map<URI, CacheManager> cacheManagersByURI = this.cacheManagers.remove(managerClassLoader);
            if (cacheManagersByURI != null) {
                for (CacheManager cacheManager : cacheManagersByURI.values()) {
                    cacheManager.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(URI uri, ClassLoader classLoader) {
        Map<ClassLoader, Map<URI, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ClassLoader managerClassLoader = this.getManagerClassLoader(classLoader);
            Map<URI, CacheManager> cacheManagersByURI = this.cacheManagers.get(managerClassLoader);
            if (cacheManagersByURI != null) {
                CacheManager cacheManager = cacheManagersByURI.remove(this.getManagerUri(uri));
                if (cacheManager != null) {
                    cacheManager.close();
                }
                if (cacheManagersByURI.isEmpty()) {
                    this.cacheManagers.remove(managerClassLoader);
                }
            }
        }
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        switch (optionalFeature) {
            case STORE_BY_REFERENCE: {
                return true;
            }
        }
        return false;
    }

    private URI getManagerUri(URI uri) {
        return uri == null ? this.getDefaultURI() : uri;
    }

    private ClassLoader getManagerClassLoader(ClassLoader classLoader) {
        return classLoader == null ? this.getDefaultClassLoader() : classLoader;
    }
}

