/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.rtftohtml.impl;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Objects;
import java.util.regex.Matcher;
import org.bbottema.rtftohtml.RTF2HTMLConverter;
import org.bbottema.rtftohtml.impl.util.ByteUtil;
import org.bbottema.rtftohtml.impl.util.CharsetHelper;
import org.bbottema.rtftohtml.impl.util.CodePage;
import org.jetbrains.annotations.NotNull;

public class RTF2HTMLConverterRFCCompliant
implements RTF2HTMLConverter {
    public static final RTF2HTMLConverter INSTANCE = new RTF2HTMLConverterRFCCompliant();

    private RTF2HTMLConverterRFCCompliant() {
    }

    @Override
    @NotNull
    public String rtf2html(@NotNull String rtf) {
        HashMap<Integer, FontTableEntry> fontTable = new HashMap<Integer, FontTableEntry>();
        Charset charset = CharsetHelper.detectCharsetFromRtfContent(rtf);
        LinkedList<Group> groupStack = new LinkedList<Group>();
        groupStack.add(new Group());
        Matcher controlWordMatcher = CONTROL_WORD.matcher(rtf);
        Matcher encodedCharMatcher = ENCODED_CHARACTER.matcher(rtf);
        StringBuilder result = new StringBuilder();
        int length = rtf.length();
        int charIndex = 0;
        block29: while (charIndex < length) {
            char c = rtf.charAt(charIndex);
            Group currentGroup = (Group)groupStack.getFirst();
            if (c == '\r' || c == '\n') {
                ++charIndex;
                continue;
            }
            if (c == '{') {
                groupStack.addFirst(currentGroup.copy());
                ++charIndex;
                continue;
            }
            if (c == '}') {
                groupStack.removeFirst();
                if (groupStack.size() == 1) break;
                ++charIndex;
                continue;
            }
            if (c == '\\') {
                encodedCharMatcher.region(charIndex, length);
                if (encodedCharMatcher.lookingAt()) {
                    FontTableEntry entry;
                    StringBuilder encodedSequence = new StringBuilder();
                    while (encodedCharMatcher.lookingAt()) {
                        encodedSequence.append(encodedCharMatcher.group(1));
                        encodedCharMatcher.region(charIndex += 4, length);
                    }
                    Charset effectiveCharset = charset;
                    if (currentGroup.fontTableIndex != null && (entry = (FontTableEntry)fontTable.get(currentGroup.fontTableIndex)) != null && entry.charset != null) {
                        effectiveCharset = entry.charset;
                    }
                    String decoded = ByteUtil.hexToString(encodedSequence.toString(), effectiveCharset);
                    this.appendIfNotIgnoredGroup(result, decoded, currentGroup);
                    continue;
                }
                controlWordMatcher.region(charIndex, length);
                if (!controlWordMatcher.lookingAt()) {
                    throw new IllegalStateException("RTF file has invalid structure. Failed to match character '" + c + "' at [" + charIndex + "/" + length + "] to a control symbol or word.");
                }
                Integer controlNumber = null;
                String controlWord = controlWordMatcher.group(2);
                if (controlWord == null) {
                    controlWord = controlWordMatcher.group(4);
                    String controlNumberString = controlWordMatcher.group(5);
                    if (!"".equals(controlNumberString)) {
                        controlNumber = Integer.valueOf(controlNumberString);
                    }
                }
                charIndex += controlWordMatcher.end() - controlWordMatcher.start();
                switch (controlWord) {
                    case "par": {
                        this.appendIfNotIgnoredGroup(result, "\n", currentGroup);
                        break;
                    }
                    case "tab": {
                        this.appendIfNotIgnoredGroup(result, "\t", currentGroup);
                        break;
                    }
                    case "htmlrtf": {
                        currentGroup.htmlRtf = controlNumber == null;
                        break;
                    }
                    case "ansicpg": {
                        charset = CharsetHelper.findCharsetForCodePage(Objects.requireNonNull(controlNumber).toString());
                        break;
                    }
                    case "fonttbl": 
                    case "colortbl": {
                        currentGroup.ignore = true;
                        break;
                    }
                    case "f": {
                        currentGroup.fontTableIndex = controlNumber;
                        break;
                    }
                    case "fcharset": {
                        if (controlNumber == null || currentGroup.fontTableIndex == null) break;
                        Charset possibleCharset = CodePage.getCharsetByCodePage(controlNumber);
                        if (possibleCharset == null) continue block29;
                        FontTableEntry entry = (FontTableEntry)fontTable.get(currentGroup.fontTableIndex);
                        if (entry == null) {
                            entry = new FontTableEntry();
                            fontTable.put(currentGroup.fontTableIndex, entry);
                        }
                        entry.charset = possibleCharset;
                        break;
                    }
                    case "uc": {
                        currentGroup.unicodeCharLength = controlNumber == null ? 1 : controlNumber;
                        break;
                    }
                    case "u": {
                        if (controlNumber == null) break;
                        char unicodeSymbol = (char)controlNumber.intValue();
                        this.appendIfNotIgnoredGroup(result, Character.toString(unicodeSymbol), currentGroup);
                        charIndex += currentGroup.unicodeCharLength;
                        break;
                    }
                    case "{": 
                    case "}": 
                    case "\\": {
                        this.appendIfNotIgnoredGroup(result, controlWord, currentGroup);
                        break;
                    }
                    case "pntext": {
                        currentGroup.ignore = true;
                        break;
                    }
                }
                continue;
            }
            this.appendIfNotIgnoredGroup(result, c + "", currentGroup);
            ++charIndex;
        }
        return result.toString();
    }

    private void appendIfNotIgnoredGroup(StringBuilder result, String symbol, Group group) {
        if (!group.ignore && !group.htmlRtf) {
            result.append(symbol);
        }
    }

    private static class FontTableEntry {
        Charset charset = null;

        private FontTableEntry() {
        }
    }

    private static class Group {
        boolean ignore = false;
        int unicodeCharLength = 1;
        boolean htmlRtf = false;
        Integer fontTableIndex = null;

        private Group() {
        }

        Group copy() {
            Group newGroup = new Group();
            newGroup.ignore = this.ignore;
            newGroup.unicodeCharLength = this.unicodeCharLength;
            newGroup.htmlRtf = this.htmlRtf;
            return newGroup;
        }
    }
}

