/*
 * Decompiled with CFR 0.152.
 */
package com.bastiaanjansen.otp.helpers;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class URIHelper {
    public static final String DIGITS = "digits";
    public static final String SECRET = "secret";
    public static final String ALGORITHM = "algorithm";
    public static final String PERIOD = "period";
    public static final String COUNTER = "counter";
    public static final String ISSUER = "issuer";

    private URIHelper() {
    }

    public static Map<String, String> queryItems(URI uri) {
        String[] pairs;
        LinkedHashMap<String, String> items = new LinkedHashMap<String, String>();
        String query = uri.getQuery();
        for (String pair : pairs = query.split("&")) {
            int index = pair.indexOf("=");
            try {
                items.put(URLDecoder.decode(pair.substring(0, index), StandardCharsets.UTF_8.toString()), URLDecoder.decode(pair.substring(index + 1), StandardCharsets.UTF_8.toString()));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Encoding should be supported");
            }
        }
        return items;
    }

    public static URI createURI(String scheme, String host, String path, Map<String, String> query) throws URISyntaxException {
        String uriString = String.format("%s://%s/%s?", scheme, host, path);
        String uri = query.keySet().stream().map(key -> String.format("%s=%s", key, URIHelper.encode((String)query.get(key)))).collect(Collectors.joining("&", uriString, ""));
        return new URI(uri);
    }

    public static String encode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

