/*
 * Decompiled with CFR 0.152.
 */
package com.shockwave.pdfium;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.view.Surface;
import com.shockwave.pdfium.PdfDocument;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;

public class PdfiumCore {
    private static final String TAG = PdfiumCore.class.getName();
    private static final Class FD_CLASS;
    private static final String FD_FIELD_NAME = "descriptor";
    private static Field mFdField;
    private int mCurrentDpi;
    private static final Object lock;

    private native long nativeOpenDocument(int var1);

    private native void nativeCloseDocument(long var1);

    private native int nativeGetPageCount(long var1);

    private native long nativeLoadPage(long var1, int var3);

    private native long[] nativeLoadPages(long var1, int var3, int var4);

    private native void nativeClosePage(long var1);

    private native void nativeClosePages(long[] var1);

    private native int nativeGetPageWidthPixel(long var1, int var3);

    private native int nativeGetPageHeightPixel(long var1, int var3);

    private native int nativeGetPageWidthPoint(long var1);

    private native int nativeGetPageHeightPoint(long var1);

    private native void nativeRenderPage(long var1, Surface var3, int var4, int var5, int var6, int var7, int var8);

    private native void nativeRenderPageBitmap(long var1, Bitmap var3, int var4, int var5, int var6, int var7, int var8);

    public PdfiumCore(Context ctx) {
        this.mCurrentDpi = ctx.getResources().getDisplayMetrics().densityDpi;
    }

    public static int getNumFd(ParcelFileDescriptor fdObj) {
        try {
            if (mFdField == null) {
                mFdField = FD_CLASS.getDeclaredField(FD_FIELD_NAME);
                mFdField.setAccessible(true);
            }
            return mFdField.getInt(fdObj.getFileDescriptor());
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return -1;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdfDocument newDocument(ParcelFileDescriptor fd) throws IOException {
        PdfDocument document = new PdfDocument();
        document.parcelFileDescriptor = fd;
        Object object = lock;
        synchronized (object) {
            document.mNativeDocPtr = this.nativeOpenDocument(PdfiumCore.getNumFd(fd));
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageCount(PdfDocument doc) {
        Object object = lock;
        synchronized (object) {
            return this.nativeGetPageCount(doc.mNativeDocPtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long openPage(PdfDocument doc, int pageIndex) {
        long pagePtr;
        Object object = lock;
        synchronized (object) {
            pagePtr = this.nativeLoadPage(doc.mNativeDocPtr, pageIndex);
        }
        object = doc.Lock;
        synchronized (object) {
            doc.mNativePagesPtr.put(pageIndex, pagePtr);
            return pagePtr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] openPage(PdfDocument doc, int fromIndex, int toIndex) {
        long[] pagesPtr;
        Object object = lock;
        synchronized (object) {
            pagesPtr = this.nativeLoadPages(doc.mNativeDocPtr, fromIndex, toIndex);
        }
        object = doc.Lock;
        synchronized (object) {
            int pageIndex = fromIndex;
            for (long page : pagesPtr) {
                if (pageIndex > toIndex) break;
                doc.mNativePagesPtr.put(pageIndex, page);
                ++pageIndex;
            }
            return pagesPtr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageWidth(PdfDocument doc, int index) {
        Object object = lock;
        synchronized (object) {
            Long pagePtr = doc.mNativePagesPtr.get(index);
            if (pagePtr != null) {
                return this.nativeGetPageWidthPixel(pagePtr, this.mCurrentDpi);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageHeight(PdfDocument doc, int index) {
        Object object = lock;
        synchronized (object) {
            Long pagePtr = doc.mNativePagesPtr.get(index);
            if (pagePtr != null) {
                return this.nativeGetPageHeightPixel(pagePtr, this.mCurrentDpi);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageWidthPoint(PdfDocument doc, int index) {
        Object object = lock;
        synchronized (object) {
            Long pagePtr = doc.mNativePagesPtr.get(index);
            if (pagePtr != null) {
                return this.nativeGetPageWidthPoint(pagePtr);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageHeightPoint(PdfDocument doc, int index) {
        Object object = lock;
        synchronized (object) {
            Long pagePtr = doc.mNativePagesPtr.get(index);
            if (pagePtr != null) {
                return this.nativeGetPageHeightPoint(pagePtr);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderPage(PdfDocument doc, Surface surface, int pageIndex, int startX, int startY, int drawSizeX, int drawSizeY) {
        Object object = lock;
        synchronized (object) {
            try {
                this.nativeRenderPage(doc.mNativePagesPtr.get(pageIndex), surface, this.mCurrentDpi, startX, startY, drawSizeX, drawSizeY);
            }
            catch (NullPointerException e) {
                Log.e((String)TAG, (String)"mContext may be null");
                e.printStackTrace();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception throw from native");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderPageBitmap(PdfDocument doc, Bitmap bitmap, int pageIndex, int startX, int startY, int drawSizeX, int drawSizeY) {
        Object object = lock;
        synchronized (object) {
            try {
                this.nativeRenderPageBitmap(doc.mNativePagesPtr.get(pageIndex), bitmap, this.mCurrentDpi, startX, startY, drawSizeX, drawSizeY);
            }
            catch (NullPointerException e) {
                Log.e((String)TAG, (String)"mContext may be null");
                e.printStackTrace();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception throw from native");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDocument(PdfDocument doc) {
        Object object = lock;
        synchronized (object) {
            for (Integer index : doc.mNativePagesPtr.keySet()) {
                this.nativeClosePage(doc.mNativePagesPtr.get(index));
            }
            doc.mNativePagesPtr.clear();
            this.nativeCloseDocument(doc.mNativeDocPtr);
            try {
                doc.parcelFileDescriptor.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            doc.parcelFileDescriptor = null;
        }
    }

    static {
        System.loadLibrary("modpdfium");
        System.loadLibrary("jniPdfium");
        FD_CLASS = FileDescriptor.class;
        mFdField = null;
        lock = new Object();
    }
}

