/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewpager.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.github.barteksc.pdfviewpager.R;
import com.github.barteksc.pdfviewpager.util.Util;
import com.github.barteksc.pdfviewpager.view.ScrollBarPageIndicator;
import fr.castorflex.android.verticalviewpager.VerticalViewPager;

public class ScrollBar
extends View
implements ViewPager.OnPageChangeListener {
    private static final String TAG = ScrollBar.class.getSimpleName();
    private int handleColor = 0;
    private int indicatorColor = 0;
    private int indicatorTextColor = 0;
    private Paint handlePaint;
    private float handleHeight = 0.0f;
    private int viewWidth;
    private VerticalViewPager viewPager;
    private PointF handlePos;
    private ViewPager.OnPageChangeListener viewPagerListener;
    private int viewPagerScrollState = 0;
    private int currentPage = 0;
    private ScrollBarPageIndicator indicator;
    private boolean programmaticPageChangeLocked = false;

    public ScrollBar(Context context) {
        super(context);
        this.init();
    }

    public ScrollBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(attrs, 0);
        this.init();
    }

    public ScrollBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.indicator = new ScrollBarPageIndicator(this.getContext());
        this.setIndicatorPage(this.currentPage);
        this.indicator.setBackgroundColor(this.indicatorColor);
        this.indicator.setTextColor(this.indicatorTextColor);
        this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                ScrollBar.this.indicator.addToScrollBar(ScrollBar.this);
                ScrollBar.this.removeOnLayoutChangeListener(this);
            }
        });
        this.handlePaint = new Paint(1);
        this.handlePaint.setStyle(Paint.Style.FILL);
        this.handlePaint.setColor(this.handleColor);
        if (this.getBackground() == null) {
            this.setBackgroundColor(-3355444);
        }
        this.handlePos = new PointF(0.0f, 0.0f);
        this.viewWidth = Util.getDP(this.getContext(), 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttrs(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.ScrollBar, defStyleAttr, 0);
        try {
            this.handleColor = a.getColor(R.styleable.ScrollBar_sb_handleColor, Color.parseColor((String)"#FF4081"));
            this.indicatorColor = a.getColor(R.styleable.ScrollBar_sb_indicatorColor, Color.parseColor((String)"#FF4081"));
            this.indicatorTextColor = a.getColor(R.styleable.ScrollBar_sb_indicatorTextColor, -1);
        }
        finally {
            a.recycle();
        }
    }

    public void setVerticalViewPager(VerticalViewPager viewPager) {
        if (this.viewPager == viewPager || viewPager == null) {
            return;
        }
        if (viewPager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.viewPager = viewPager;
        viewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.invalidate();
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.viewPagerListener = listener;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.isViewPagerReady()) {
            this.calculateHandleHeight();
            this.calculateHandlePosByPage(this.currentPage);
        }
    }

    float getHandleHeight() {
        return this.handleHeight;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minw = this.getPaddingLeft() + this.getPaddingRight() + this.viewWidth;
        int w = ScrollBar.resolveSizeAndState((int)minw, (int)widthMeasureSpec, (int)1);
        int minh = View.MeasureSpec.getSize((int)heightMeasureSpec) + this.getPaddingBottom() + this.getPaddingTop();
        int h = ScrollBar.resolveSizeAndState((int)minh, (int)heightMeasureSpec, (int)0);
        this.setMeasuredDimension(w, h);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode()) {
            canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)Util.getDP(this.getContext(), 40), this.handlePaint);
            return;
        }
        if (!this.isViewPagerReady()) {
            return;
        }
        this.calculateHandleHeight();
        canvas.drawRect(this.handlePos.x, this.handlePos.y, (float)this.getWidth(), this.handlePos.y + this.handleHeight, this.handlePaint);
    }

    private void calculateHandlePosByPage(int position) {
        this.handlePos.y = (float)position * this.handleHeight;
    }

    private void calculateHandleHeight() {
        this.handleHeight = (float)this.getHeight() / (float)this.viewPager.getAdapter().getCount();
    }

    private boolean isViewPagerReady() {
        return this.viewPager != null && this.viewPager.getAdapter() != null;
    }

    private int getPagesCount() {
        return this.isViewPagerReady() ? this.viewPager.getAdapter().getCount() : 0;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: 
            case 2: 
            case 5: {
                float y = event.getY();
                if (y < 0.0f || y > (float)this.getHeight()) {
                    return true;
                }
                int pageNum = (int)Math.floor(y / this.handleHeight);
                float handleY = (float)pageNum * this.handleHeight;
                if (handleY < 0.0f) {
                    handleY = 0.0f;
                } else if (y + this.handleHeight / 2.0f > (float)this.getHeight()) {
                    handleY = (float)this.getHeight() - this.handleHeight;
                }
                this.handlePos.y = handleY;
                if (pageNum != this.currentPage) {
                    this.indicator.setPageNum(pageNum + 1);
                }
                this.currentPage = pageNum;
                this.indicator.setVisibility(0);
                this.indicator.setScroll(handleY);
                this.invalidate();
                return true;
            }
            case 1: 
            case 3: 
            case 6: {
                int pgNum = (int)Math.floor(event.getY() / this.handleHeight);
                this.programmaticPageChangeLocked = true;
                this.viewPager.setCurrentItem(pgNum);
                this.currentPage = pgNum;
                this.indicator.setVisibility(4);
                this.invalidate();
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (!this.programmaticPageChangeLocked) {
            this.currentPage = position;
            this.handlePos.y = (float)position * this.handleHeight + positionOffset * this.handleHeight;
            this.invalidate();
        }
        if (this.viewPagerListener != null) {
            this.viewPagerListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (!this.programmaticPageChangeLocked) {
            this.currentPage = position;
            this.calculateHandlePosByPage(position);
            this.invalidate();
        }
        if (this.viewPagerListener != null) {
            this.viewPagerListener.onPageSelected(position);
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (this.programmaticPageChangeLocked && state == 0) {
            this.programmaticPageChangeLocked = false;
        }
        if (!this.programmaticPageChangeLocked) {
            this.viewPagerScrollState = state;
        }
        if (this.viewPagerListener != null) {
            this.viewPagerListener.onPageScrollStateChanged(state);
        }
    }

    public void setCurrentItem(int position) {
        if (!this.isViewPagerReady()) {
            throw new IllegalStateException("ViewPager not set");
        }
        this.programmaticPageChangeLocked = true;
        this.currentPage = position;
        this.viewPager.setCurrentItem(position);
        this.invalidate();
    }

    private void setIndicatorPage(int position) {
        this.indicator.setPageNum(position + 1);
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.currentPage = savedState.currentPage;
        this.setIndicatorPage(this.currentPage);
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.currentPage = this.currentPage;
        return savedState;
    }

    static class SavedState
    extends View.BaseSavedState {
        int currentPage;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.currentPage = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.currentPage);
        }
    }
}

