/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewpager.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.support.v4.view.PagerAdapter;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.github.barteksc.pdfviewpager.R;
import com.github.barteksc.pdfviewpager.async.PdfRenderPageAsyncTask;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.PdfiumCore;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;

public class PDFPagerAdapter
extends PagerAdapter {
    String pdfPath;
    Context context;
    PdfiumCore pdfiumCore;
    PdfDocument pdfDocument;
    SparseArray<WeakReference<Bitmap>> bitmaps;
    SparseArray<WeakReference<PdfRenderPageAsyncTask>> asyncTasks;
    LayoutInflater inflater;

    public PDFPagerAdapter(Context context, String pdfPath) {
        this.pdfPath = pdfPath;
        this.context = context;
        this.bitmaps = new SparseArray();
        this.asyncTasks = new SparseArray();
        this.init();
    }

    protected void init() {
        try {
            this.pdfiumCore = new PdfiumCore(this.context);
            this.pdfDocument = this.pdfiumCore.newDocument(this.getSeekableFileDescriptor(this.pdfPath));
            this.inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)"PDFPagerAdapter", (String)e.getMessage());
        }
    }

    protected FileDescriptor getSeekableFileDescriptor(String path) throws IOException {
        ParcelFileDescriptor pfd;
        File pdfCopy = new File(path);
        if (pdfCopy.exists()) {
            ParcelFileDescriptor pfd2 = ParcelFileDescriptor.open((File)pdfCopy, (int)0x10000000);
            return pfd2.getFileDescriptor();
        }
        if (this.isAnAsset(path)) {
            pdfCopy = new File(this.context.getCacheDir(), path);
            pfd = ParcelFileDescriptor.open((File)pdfCopy, (int)0x10000000);
        } else {
            URI uri = URI.create(String.format("file://%s", path));
            pfd = this.context.getContentResolver().openFileDescriptor(Uri.parse((String)uri.toString()), "rw");
        }
        if (pfd == null) {
            throw new IOException("Cannot get FileDescriptor for " + path);
        }
        return pfd.getFileDescriptor();
    }

    private boolean isAnAsset(String path) {
        return !path.startsWith("/");
    }

    public Object instantiateItem(ViewGroup container, int position) {
        View v = this.inflater.inflate(R.layout.view_pdf_page, container, false);
        ImageView iv = (ImageView)v.findViewById(R.id.imageView);
        if (!this.pdfiumReady() || this.getCount() < position) {
            return v;
        }
        this.executeRenderTask(iv, position, new PdfRenderPageAsyncTask.OnPdfPageRenderListener(){

            @Override
            public void onPageRendered(int position, ImageView imageView, Bitmap bitmap) {
                PDFPagerAdapter.this.bitmaps.put(position, new WeakReference<Bitmap>(bitmap));
            }
        });
        container.addView(v, 0);
        return v;
    }

    protected void executeRenderTask(ImageView imageView, int position, PdfRenderPageAsyncTask.OnPdfPageRenderListener listener) {
        PdfRenderPageAsyncTask task = new PdfRenderPageAsyncTask(imageView, position, this.pdfiumCore, this.pdfDocument).setOnPdfPageRenderListener(listener);
        this.asyncTasks.put(position, new WeakReference<PdfRenderPageAsyncTask>(task));
        task.execute(new Void[0]);
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
        WeakReference bitmapRef = (WeakReference)this.bitmaps.get(position);
        if (bitmapRef != null) {
            this.recycleBitmap(position);
        }
        this.cancelRenderTask(position);
    }

    public void close() {
        this.releaseAllBitmaps();
        this.cancelAllRenderTasks();
        if (this.pdfiumReady()) {
            this.pdfiumCore.closeDocument(this.pdfDocument);
        }
    }

    protected void releaseAllBitmaps() {
        for (int i = 0; this.bitmaps != null && i < this.bitmaps.size(); ++i) {
            this.recycleBitmap(this.bitmaps.keyAt(i));
        }
        this.bitmaps.clear();
    }

    protected void recycleBitmap(int position) {
        Bitmap b = (Bitmap)((WeakReference)this.bitmaps.get(position)).get();
        if (b != null && !b.isRecycled()) {
            b.recycle();
            this.bitmaps.remove(position);
        }
    }

    protected void cancelAllRenderTasks() {
        for (int i = 0; this.asyncTasks != null && i < this.asyncTasks.size(); ++i) {
            this.cancelRenderTask(this.asyncTasks.keyAt(i));
        }
        this.asyncTasks.clear();
    }

    protected void cancelRenderTask(int position) {
        WeakReference asyncTaskRef = (WeakReference)this.asyncTasks.get(position);
        if (asyncTaskRef != null) {
            if (asyncTaskRef.get() != null) {
                ((PdfRenderPageAsyncTask)((Object)asyncTaskRef.get())).cancel(true);
            }
            this.asyncTasks.remove(position);
        }
    }

    public int getCount() {
        return this.pdfiumReady() ? this.pdfiumCore.getPageCount(this.pdfDocument) : 0;
    }

    protected boolean pdfiumReady() {
        return this.pdfiumCore != null && this.pdfDocument != null;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }
}

