/*
 * Original work Copyright (C) 2016 Olmo Gallegos Hernández.
 * Modified work Copyright (C) 2016 Bartosz Schiller.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.barteksc.pdfviewpager.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.github.barteksc.pdfviewpager.R;
import com.github.barteksc.pdfviewpager.async.PdfRenderPageAsyncTask;

import java.lang.ref.WeakReference;

import it.sephiroth.android.library.imagezoom.ImageViewTouch;

public class PDFPagerAdapterIVZoom extends PDFPagerAdapter {

    public PDFPagerAdapterIVZoom(Context context, String pdfPath) {
        super(context, pdfPath);
    }

    @Override
    public Object instantiateItem(ViewGroup container, int position) {
        View v = inflater.inflate(R.layout.view_zoomable_pdf_page, container, false);
        ImageViewTouch ivt = (ImageViewTouch) v.findViewById(R.id.imageViewZoom);

        if (!pdfiumReady() || getCount() < position)
            return v;

        executeRenderTask(ivt, position, new PdfRenderPageAsyncTask.OnPdfPageRenderListener() {
            @Override
            public void onPageRendered(int position, ImageView imageView, Bitmap bitmap) {
                bitmaps.put(position, new WeakReference<>(bitmap));
            }
        });

        container.addView(v, 0);

        return v;
    }
}
